/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.task.reload;

import com.dianping.cat.Cat;
import com.dianping.cat.config.server.ServerConfigManager;
import com.dianping.cat.core.dal.HourlyReport;
import com.dianping.cat.core.dal.HourlyReportContent;
import com.dianping.cat.core.dal.HourlyReportContentDao;
import com.dianping.cat.core.dal.HourlyReportDao;
import com.dianping.cat.report.task.reload.ReportReloadEntity;
import com.dianping.cat.report.task.reload.ReportReloader;
import java.util.List;
import org.unidal.dal.jdbc.DalException;
import org.unidal.lookup.annotation.Inject;

public abstract class AbstractReportReloader
implements ReportReloader {
    @Inject
    protected HourlyReportDao m_hourlyReportDao;
    @Inject
    protected HourlyReportContentDao m_hourlyReportContentDao;
    @Inject
    protected ServerConfigManager m_serverConfigManager;

    protected int getAnalyzerCount() {
        return this.m_serverConfigManager.getThreadsOfRealtimeAnalyzer(this.getId());
    }

    public boolean insertHourlyReport(ReportReloadEntity entity) {
        try {
            HourlyReport report = entity.getReport();
            this.m_hourlyReportDao.insert(report);
            int id = report.getId();
            HourlyReportContent proto = this.m_hourlyReportContentDao.createLocal();
            proto.setReportId(id);
            proto.setContent(entity.getReportContent());
            proto.setPeriod(report.getPeriod());
            this.m_hourlyReportContentDao.insert(proto);
            return true;
        }
        catch (DalException e) {
            Cat.logError((Throwable)e);
            return false;
        }
    }

    public boolean reload(long time) {
        try {
            List reports = this.loadReport(time);
            for (ReportReloadEntity entity : reports) {
                this.insertHourlyReport(entity);
            }
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        return true;
    }
}

