/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.task.reload;

import com.dianping.cat.Cat;
import com.dianping.cat.config.ReportReloadConfigManager;
import com.dianping.cat.helper.TimeHelper;
import com.dianping.cat.report.task.reload.ReportReloader;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.unidal.helper.Threads;
import org.unidal.lookup.ContainerHolder;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named
public class ReportReloadTask
extends ContainerHolder
implements Initializable,
Threads.Task {
    private static final long DURATION = 3600000L;
    @Inject
    private ReportReloadConfigManager m_configManager;
    private Map<String, ReportReloader> m_reloaders;

    public String getName() {
        return "report-reload-task";
    }

    public void initialize() throws InitializationException {
        this.m_reloaders = this.lookupMap(ReportReloader.class);
    }

    public void run() {
        boolean active = TimeHelper.sleepToNextMinute();
        while (active) {
            long current = System.currentTimeMillis();
            try {
                for (Map.Entry entry : this.m_reloaders.entrySet()) {
                    String type = (String)entry.getKey();
                    List dates = this.m_configManager.queryByReportType(type);
                    for (Date date : dates) {
                        ReportReloader reloader = (ReportReloader)entry.getValue();
                        reloader.reload(date.getTime());
                    }
                }
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
            }
            long duration = System.currentTimeMillis() - current;
            try {
                if (duration >= 3600000L) continue;
                Thread.sleep(3600000L - duration);
            }
            catch (InterruptedException e) {
                active = false;
            }
        }
    }

    public void shutdown() {
    }
}

