/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.task.reload.impl;

import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.consumer.business.BusinessReportMerger;
import com.dianping.cat.consumer.business.model.IVisitor;
import com.dianping.cat.consumer.business.model.entity.BusinessReport;
import com.dianping.cat.consumer.business.model.transform.DefaultNativeBuilder;
import com.dianping.cat.core.dal.HourlyReport;
import com.dianping.cat.report.ReportManager;
import com.dianping.cat.report.task.reload.AbstractReportReloader;
import com.dianping.cat.report.task.reload.ReportReloadEntity;
import com.dianping.cat.report.task.reload.ReportReloader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=ReportReloader.class, value="business")
public class BusinessReportReloader
extends AbstractReportReloader {
    @Inject(value={"business"})
    protected ReportManager<BusinessReport> m_reportManager;

    private List<BusinessReport> buildMergedReports(Map<String, List<BusinessReport>> mergedReports) {
        ArrayList<BusinessReport> results = new ArrayList<BusinessReport>();
        for (Map.Entry<String, List<BusinessReport>> entry : mergedReports.entrySet()) {
            String domain = entry.getKey();
            BusinessReport report = new BusinessReport(domain);
            BusinessReportMerger merger = new BusinessReportMerger(report);
            report.setStartTime(report.getStartTime());
            report.setEndTime(report.getEndTime());
            for (BusinessReport r : entry.getValue()) {
                r.accept((IVisitor)merger);
            }
            results.add(merger.getBusinessReport());
        }
        return results;
    }

    public String getId() {
        return "business";
    }

    public List<ReportReloadEntity> loadReport(long time) {
        ArrayList<ReportReloadEntity> results = new ArrayList<ReportReloadEntity>();
        HashMap<String, ArrayList<BusinessReport>> mergedReports = new HashMap<String, ArrayList<BusinessReport>>();
        for (int i = 0; i < this.getAnalyzerCount(); ++i) {
            Map reports = this.m_reportManager.loadLocalReports(time, i);
            for (Map.Entry entry : reports.entrySet()) {
                String domain = (String)entry.getKey();
                BusinessReport r = (BusinessReport)entry.getValue();
                ArrayList<BusinessReport> rs = (ArrayList<BusinessReport>)mergedReports.get(domain);
                if (rs == null) {
                    rs = new ArrayList<BusinessReport>();
                    mergedReports.put(domain, rs);
                }
                rs.add(r);
            }
        }
        List reports = this.buildMergedReports(mergedReports);
        for (BusinessReport r : reports) {
            HourlyReport report = new HourlyReport();
            report.setCreationDate(new Date());
            report.setDomain(r.getDomain());
            report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
            report.setName(this.getId());
            report.setPeriod(new Date(time));
            report.setType(1);
            byte[] content = DefaultNativeBuilder.build((BusinessReport)r);
            ReportReloadEntity entity = new ReportReloadEntity(report, content);
            results.add(entity);
        }
        return results;
    }
}

