/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.task.reload.impl;

import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.consumer.dependency.DependencyReportMerger;
import com.dianping.cat.consumer.dependency.model.IVisitor;
import com.dianping.cat.consumer.dependency.model.entity.DependencyReport;
import com.dianping.cat.consumer.dependency.model.transform.DefaultNativeBuilder;
import com.dianping.cat.core.dal.HourlyReport;
import com.dianping.cat.report.ReportManager;
import com.dianping.cat.report.task.reload.AbstractReportReloader;
import com.dianping.cat.report.task.reload.ReportReloadEntity;
import com.dianping.cat.report.task.reload.ReportReloader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=ReportReloader.class, value="dependency")
public class DependencyReportReloader
extends AbstractReportReloader {
    @Inject(value={"dependency"})
    protected ReportManager<DependencyReport> m_reportManager;

    private List<DependencyReport> buildMergedReports(Map<String, List<DependencyReport>> mergedReports) {
        ArrayList<DependencyReport> results = new ArrayList<DependencyReport>();
        for (Map.Entry<String, List<DependencyReport>> entry : mergedReports.entrySet()) {
            String domain = entry.getKey();
            DependencyReport report = new DependencyReport(domain);
            DependencyReportMerger merger = new DependencyReportMerger(report);
            report.setStartTime(report.getStartTime());
            report.setEndTime(report.getEndTime());
            for (DependencyReport r : entry.getValue()) {
                r.accept((IVisitor)merger);
            }
            results.add(merger.getDependencyReport());
        }
        return results;
    }

    public String getId() {
        return "dependency";
    }

    public List<ReportReloadEntity> loadReport(long time) {
        ArrayList<ReportReloadEntity> results = new ArrayList<ReportReloadEntity>();
        HashMap<String, ArrayList<DependencyReport>> mergedReports = new HashMap<String, ArrayList<DependencyReport>>();
        for (int i = 0; i < this.getAnalyzerCount(); ++i) {
            Map reports = this.m_reportManager.loadLocalReports(time, i);
            for (Map.Entry entry : reports.entrySet()) {
                String domain = (String)entry.getKey();
                DependencyReport r = (DependencyReport)entry.getValue();
                ArrayList<DependencyReport> rs = (ArrayList<DependencyReport>)mergedReports.get(domain);
                if (rs == null) {
                    rs = new ArrayList<DependencyReport>();
                    mergedReports.put(domain, rs);
                }
                rs.add(r);
            }
        }
        List reports = this.buildMergedReports(mergedReports);
        for (DependencyReport r : reports) {
            HourlyReport report = new HourlyReport();
            report.setCreationDate(new Date());
            report.setDomain(r.getDomain());
            report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
            report.setName(this.getId());
            report.setPeriod(new Date(time));
            report.setType(1);
            byte[] content = DefaultNativeBuilder.build((DependencyReport)r);
            ReportReloadEntity entity = new ReportReloadEntity(report, content);
            results.add(entity);
        }
        return results;
    }
}

