/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.task.reload.impl;

import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.consumer.event.EventReportMerger;
import com.dianping.cat.consumer.event.model.IVisitor;
import com.dianping.cat.consumer.event.model.entity.EventReport;
import com.dianping.cat.consumer.event.model.transform.DefaultNativeBuilder;
import com.dianping.cat.core.dal.HourlyReport;
import com.dianping.cat.report.ReportManager;
import com.dianping.cat.report.task.reload.AbstractReportReloader;
import com.dianping.cat.report.task.reload.ReportReloadEntity;
import com.dianping.cat.report.task.reload.ReportReloader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=ReportReloader.class, value="event")
public class EventReportReloader
extends AbstractReportReloader {
    @Inject(value={"event"})
    protected ReportManager<EventReport> m_reportManager;

    private List<EventReport> buildMergedReports(Map<String, List<EventReport>> mergedReports) {
        ArrayList<EventReport> results = new ArrayList<EventReport>();
        for (Map.Entry<String, List<EventReport>> entry : mergedReports.entrySet()) {
            String domain = entry.getKey();
            EventReport report = new EventReport(domain);
            EventReportMerger merger = new EventReportMerger(report);
            report.setStartTime(report.getStartTime());
            report.setEndTime(report.getEndTime());
            for (EventReport r : entry.getValue()) {
                r.accept((IVisitor)merger);
            }
            results.add(merger.getEventReport());
        }
        return results;
    }

    public String getId() {
        return "event";
    }

    public List<ReportReloadEntity> loadReport(long time) {
        ArrayList<ReportReloadEntity> results = new ArrayList<ReportReloadEntity>();
        HashMap<String, ArrayList<EventReport>> mergedReports = new HashMap<String, ArrayList<EventReport>>();
        for (int i = 0; i < this.getAnalyzerCount(); ++i) {
            Map reports = this.m_reportManager.loadLocalReports(time, i);
            for (Map.Entry entry : reports.entrySet()) {
                String domain = (String)entry.getKey();
                EventReport r = (EventReport)entry.getValue();
                ArrayList<EventReport> rs = (ArrayList<EventReport>)mergedReports.get(domain);
                if (rs == null) {
                    rs = new ArrayList<EventReport>();
                    mergedReports.put(domain, rs);
                }
                rs.add(r);
            }
        }
        List reports = this.buildMergedReports(mergedReports);
        for (EventReport r : reports) {
            HourlyReport report = new HourlyReport();
            report.setCreationDate(new Date());
            report.setDomain(r.getDomain());
            report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
            report.setName(this.getId());
            report.setPeriod(new Date(time));
            report.setType(1);
            byte[] content = DefaultNativeBuilder.build((EventReport)r);
            ReportReloadEntity entity = new ReportReloadEntity(report, content);
            results.add(entity);
        }
        return results;
    }
}

