/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.task.reload.impl;

import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.consumer.problem.ProblemReportMerger;
import com.dianping.cat.consumer.problem.model.IVisitor;
import com.dianping.cat.consumer.problem.model.entity.ProblemReport;
import com.dianping.cat.consumer.problem.model.transform.DefaultNativeBuilder;
import com.dianping.cat.core.dal.HourlyReport;
import com.dianping.cat.report.ReportManager;
import com.dianping.cat.report.task.reload.AbstractReportReloader;
import com.dianping.cat.report.task.reload.ReportReloadEntity;
import com.dianping.cat.report.task.reload.ReportReloader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=ReportReloader.class, value="problem")
public class ProblemReportReloader
extends AbstractReportReloader {
    @Inject(value={"problem"})
    protected ReportManager<ProblemReport> m_reportManager;

    private List<ProblemReport> buildMergedReports(Map<String, List<ProblemReport>> mergedReports) {
        ArrayList<ProblemReport> results = new ArrayList<ProblemReport>();
        for (Map.Entry<String, List<ProblemReport>> entry : mergedReports.entrySet()) {
            String domain = entry.getKey();
            ProblemReport report = new ProblemReport(domain);
            ProblemReportMerger merger = new ProblemReportMerger(report);
            report.setStartTime(report.getStartTime());
            report.setEndTime(report.getEndTime());
            for (ProblemReport r : entry.getValue()) {
                r.accept((IVisitor)merger);
            }
            results.add(merger.getProblemReport());
        }
        return results;
    }

    public String getId() {
        return "problem";
    }

    public List<ReportReloadEntity> loadReport(long time) {
        ArrayList<ReportReloadEntity> results = new ArrayList<ReportReloadEntity>();
        HashMap<String, ArrayList<ProblemReport>> mergedReports = new HashMap<String, ArrayList<ProblemReport>>();
        for (int i = 0; i < this.getAnalyzerCount(); ++i) {
            Map reports = this.m_reportManager.loadLocalReports(time, i);
            for (Map.Entry entry : reports.entrySet()) {
                String domain = (String)entry.getKey();
                ProblemReport r = (ProblemReport)entry.getValue();
                ArrayList<ProblemReport> rs = (ArrayList<ProblemReport>)mergedReports.get(domain);
                if (rs == null) {
                    rs = new ArrayList<ProblemReport>();
                    mergedReports.put(domain, rs);
                }
                rs.add(r);
            }
        }
        List reports = this.buildMergedReports(mergedReports);
        for (ProblemReport r : reports) {
            HourlyReport report = new HourlyReport();
            report.setCreationDate(new Date());
            report.setDomain(r.getDomain());
            report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
            report.setName(this.getId());
            report.setPeriod(new Date(time));
            report.setType(1);
            byte[] content = DefaultNativeBuilder.build((ProblemReport)r);
            ReportReloadEntity entity = new ReportReloadEntity(report, content);
            results.add(entity);
        }
        return results;
    }
}

