/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.task.reload.impl;

import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.consumer.transaction.TransactionReportMerger;
import com.dianping.cat.consumer.transaction.model.IVisitor;
import com.dianping.cat.consumer.transaction.model.entity.TransactionReport;
import com.dianping.cat.consumer.transaction.model.transform.DefaultNativeBuilder;
import com.dianping.cat.core.dal.HourlyReport;
import com.dianping.cat.report.ReportManager;
import com.dianping.cat.report.task.reload.AbstractReportReloader;
import com.dianping.cat.report.task.reload.ReportReloadEntity;
import com.dianping.cat.report.task.reload.ReportReloader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=ReportReloader.class, value="transaction")
public class TransactionReportReloader
extends AbstractReportReloader {
    @Inject(value={"transaction"})
    protected ReportManager<TransactionReport> m_reportManager;

    private List<TransactionReport> buildMergedReports(Map<String, List<TransactionReport>> mergedReports) {
        ArrayList<TransactionReport> results = new ArrayList<TransactionReport>();
        for (Map.Entry<String, List<TransactionReport>> entry : mergedReports.entrySet()) {
            String domain = entry.getKey();
            TransactionReport report = new TransactionReport(domain);
            TransactionReportMerger merger = new TransactionReportMerger(report);
            report.setStartTime(report.getStartTime());
            report.setEndTime(report.getEndTime());
            for (TransactionReport r : entry.getValue()) {
                r.accept((IVisitor)merger);
            }
            results.add(merger.getTransactionReport());
        }
        return results;
    }

    public String getId() {
        return "transaction";
    }

    public List<ReportReloadEntity> loadReport(long time) {
        ArrayList<ReportReloadEntity> results = new ArrayList<ReportReloadEntity>();
        HashMap<String, ArrayList<TransactionReport>> mergedReports = new HashMap<String, ArrayList<TransactionReport>>();
        for (int i = 0; i < this.getAnalyzerCount(); ++i) {
            Map reports = this.m_reportManager.loadLocalReports(time, i);
            for (Map.Entry entry : reports.entrySet()) {
                String domain = (String)entry.getKey();
                TransactionReport r = (TransactionReport)entry.getValue();
                ArrayList<TransactionReport> rs = (ArrayList<TransactionReport>)mergedReports.get(domain);
                if (rs == null) {
                    rs = new ArrayList<TransactionReport>();
                    mergedReports.put(domain, rs);
                }
                rs.add(r);
            }
        }
        List reports = this.buildMergedReports(mergedReports);
        for (TransactionReport r : reports) {
            HourlyReport report = new HourlyReport();
            report.setCreationDate(new Date());
            report.setDomain(r.getDomain());
            report.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
            report.setName(this.getId());
            report.setPeriod(new Date(time));
            report.setType(1);
            byte[] content = DefaultNativeBuilder.build((TransactionReport)r);
            ReportReloadEntity entity = new ReportReloadEntity(report, content);
            results.add(entity);
        }
        return results;
    }
}

