/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.system.page.business;

import com.dianping.cat.alarm.rule.entity.Rule;
import com.dianping.cat.alarm.rule.transform.DefaultJsonBuilder;
import com.dianping.cat.alarm.spi.decorator.RuleFTLDecorator;
import com.dianping.cat.config.business.BusinessConfigManager;
import com.dianping.cat.config.business.ConfigItem;
import com.dianping.cat.configuration.business.entity.BusinessItemConfig;
import com.dianping.cat.configuration.business.entity.BusinessReportConfig;
import com.dianping.cat.configuration.business.entity.CustomConfig;
import com.dianping.cat.report.alert.business.BusinessRuleConfigManager;
import com.dianping.cat.service.ProjectService;
import com.dianping.cat.system.SystemPage;
import com.dianping.cat.system.page.business.Action;
import com.dianping.cat.system.page.business.Context;
import com.dianping.cat.system.page.business.Handler;
import com.dianping.cat.system.page.business.JspViewer;
import com.dianping.cat.system.page.business.Model;
import com.dianping.cat.system.page.business.Payload;
import com.dianping.cat.system.page.business.config.BusinessTagConfigManager;
import com.dianping.cat.system.page.config.ConfigHtmlParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.servlet.ServletException;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.util.StringUtils;
import org.unidal.web.mvc.ActionContext;
import org.unidal.web.mvc.Page;
import org.unidal.web.mvc.PageHandler;
import org.unidal.web.mvc.ViewModel;
import org.unidal.web.mvc.annotation.InboundActionMeta;
import org.unidal.web.mvc.annotation.OutboundActionMeta;
import org.unidal.web.mvc.annotation.PayloadMeta;
import org.unidal.web.mvc.annotation.PreInboundActionMeta;

public class Handler
implements PageHandler<Context> {
    @Inject
    protected RuleFTLDecorator m_ruleDecorator;
    @Inject
    private JspViewer m_jspViewer;
    @Inject
    private ProjectService m_projectService;
    @Inject
    private BusinessConfigManager m_configManager;
    @Inject
    private BusinessTagConfigManager m_tagConfigManger;
    @Inject
    private BusinessRuleConfigManager m_alertConfigManager;
    @Inject
    private ConfigHtmlParser m_configHtmlParser;

    @PreInboundActionMeta(value={"login"})
    @PayloadMeta(value=Payload.class)
    @InboundActionMeta(name="business")
    public void handleInbound(Context ctx) throws ServletException, IOException {
    }

    @PreInboundActionMeta(value={"login"})
    @OutboundActionMeta(name="business")
    public void handleOutbound(Context ctx) throws ServletException, IOException {
        Model model = new Model(ctx);
        Payload payload = (Payload)ctx.getPayload();
        Action action = payload.getAction();
        String domain = payload.getDomain();
        model.setPage((Page)SystemPage.BUSINESS);
        model.setAction((org.unidal.web.mvc.Action)action);
        model.setDomains(this.m_projectService.findAllDomains());
        switch (3.$SwitchMap$com$dianping$cat$system$page$business$Action[action.ordinal()]) {
            case 1: {
                this.listConfigs(domain, model);
                break;
            }
            case 2: {
                BusinessItemConfig itemConfig;
                BusinessReportConfig config = this.m_configManager.queryConfigByDomain(domain);
                if (config == null || (itemConfig = config.findBusinessItemConfig(payload.getKey())) == null) break;
                model.setBusinessItemConfig(itemConfig);
                break;
            }
            case 3: {
                this.updateConfig(model, payload, domain);
                this.listConfigs(domain, model);
                break;
            }
            case 4: {
                String key = payload.getKey();
                this.m_configManager.deleteBusinessItem(domain, key);
                this.listConfigs(domain, model);
                break;
            }
            case 5: {
                String key = payload.getKey();
                this.m_configManager.deleteCustomItem(domain, key);
                this.listConfigs(domain, model);
                break;
            }
            case 6: {
                String tagConfig = payload.getContent();
                if (!StringUtils.isEmpty((String)tagConfig)) {
                    model.setOpState(this.m_tagConfigManger.store(tagConfig));
                }
                model.setContent(this.m_configHtmlParser.parse(this.m_tagConfigManger.getConfig().toString()));
                break;
            }
            case 7: {
                this.alertRuleAdd(payload, model);
                break;
            }
            case 8: {
                this.alertRuleAddSubmit(payload, model);
                this.listConfigs(domain, model);
                break;
            }
            case 9: {
                CustomConfig itemConfig;
                BusinessReportConfig config = this.m_configManager.queryConfigByDomain(domain);
                if (config == null || (itemConfig = config.findCustomConfig(payload.getKey())) == null) break;
                model.setCustomConfig(itemConfig);
                break;
            }
            case 10: {
                this.updateCustomConfig(model, payload, domain);
                this.listConfigs(domain, model);
            }
        }
        if (!ctx.isProcessStopped()) {
            this.m_jspViewer.view((ActionContext)ctx, (ViewModel)model);
        }
    }

    private void alertRuleAddSubmit(Payload payload, Model model) {
        String domain = payload.getDomain();
        String key = payload.getKey();
        String configs = payload.getContent();
        String type = payload.getAttributes();
        this.m_alertConfigManager.updateRule(domain, key, configs, type);
    }

    private void alertRuleAdd(Payload payload, Model model) {
        String type;
        String ruleId = "";
        String configsStr = "";
        String key = payload.getKey();
        String domain = payload.getDomain();
        Rule rule = this.m_alertConfigManager.queryRule(domain, key, type = payload.getAttributes());
        if (rule != null) {
            ruleId = rule.getId();
            configsStr = new DefaultJsonBuilder(true).buildArray((Collection)rule.getConfigs());
        }
        String content = this.m_ruleDecorator.generateConfigsHtml(configsStr);
        model.setId(ruleId);
        model.setContent(content);
    }

    private void listConfigs(String domain, Model model) {
        BusinessReportConfig config = this.m_configManager.queryConfigByDomain(domain);
        Map tags = this.m_tagConfigManger.findTagByDomain(domain);
        ArrayList configs = new ArrayList(config.getBusinessItemConfigs().values());
        Collections.sort(configs, new /* Unavailable Anonymous Inner Class!! */);
        ArrayList customConfigs = new ArrayList(config.getCustomConfigs().values());
        Collections.sort(customConfigs, new /* Unavailable Anonymous Inner Class!! */);
        model.setConfigs(configs);
        model.setCustomConfigs(customConfigs);
        model.setTags(tags);
    }

    private void updateConfig(Model model, Payload payload, String domain) {
        Map itemConfigs;
        BusinessItemConfig origin;
        BusinessItemConfig itemConfig = payload.getBusinessItemConfig();
        String key = itemConfig.getId();
        BusinessReportConfig config = this.m_configManager.queryConfigByDomain(domain);
        boolean isModify = false;
        boolean result = false;
        if (config != null && (origin = (BusinessItemConfig)(itemConfigs = config.getBusinessItemConfigs()).get(key)) != null) {
            isModify = true;
            config.addBusinessItemConfig(itemConfig);
            result = this.m_configManager.updateConfigByDomain(config);
        }
        if (!isModify) {
            ConfigItem item = new ConfigItem();
            item.setShowAvg(itemConfig.getShowAvg());
            item.setShowCount(itemConfig.getShowCount());
            item.setShowSum(itemConfig.getShowSum());
            item.setTitle(itemConfig.getTitle());
            item.setViewOrder(itemConfig.getViewOrder());
            result = this.m_configManager.insertBusinessConfigIfNotExist(domain, key, item);
        }
        model.setOpState(result);
    }

    private void updateCustomConfig(Model model, Payload payload, String domain) {
        CustomConfig itemConfig = payload.getCustomConfig();
        BusinessReportConfig config = this.m_configManager.queryConfigByDomain(domain);
        boolean result = false;
        if (StringUtils.isNotEmpty((String)itemConfig.getId())) {
            if (config.getId() != null) {
                config.addCustomConfig(itemConfig);
                result = this.m_configManager.updateConfigByDomain(config);
            } else {
                config.setId(domain);
                config.addCustomConfig(itemConfig);
                result = this.m_configManager.insertConfigByDomain(config);
            }
        }
        model.setOpState(result);
    }
}

