/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.system.page.permission;

import com.dianping.cat.Cat;
import com.dianping.cat.config.content.ContentFetcher;
import com.dianping.cat.core.config.Config;
import com.dianping.cat.core.config.ConfigDao;
import com.dianping.cat.core.config.ConfigEntity;
import com.dianping.cat.home.resource.entity.Resource;
import com.dianping.cat.home.resource.entity.ResourceConfig;
import com.dianping.cat.home.resource.transform.DefaultSaxParser;
import com.dianping.cat.task.TimerSyncTask;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.unidal.dal.jdbc.DalNotFoundException;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named
public class ResourceConfigManager
implements Initializable {
    public static final int DEFAULT_RESOURCE_ROLE = 1;
    private static final String CONFIG_NAME = "resource-config";
    private static final String ALL = "*";
    @Inject
    protected ConfigDao m_configDao;
    @Inject
    protected ContentFetcher m_fetcher;
    private int m_configId;
    private long m_modifyTime;
    private ResourceConfig m_config;
    private volatile Map<String, Map<String, Integer>> m_permissions = new ConcurrentHashMap();

    public ResourceConfig getConfig() {
        return this.m_config;
    }

    public int getRole(String path, String op) {
        Map pathPermission = (Map)this.m_permissions.get(path);
        if (pathPermission == null) {
            pathPermission = (Map)this.m_permissions.get(ALL);
        }
        if (pathPermission != null) {
            Integer role = (Integer)pathPermission.get(op);
            if (role == null) {
                role = (Integer)pathPermission.get(ALL);
            }
            if (role != null) {
                return role;
            }
        }
        return 1;
    }

    public void initialize() throws InitializationException {
        try {
            Config config = this.m_configDao.findByName(CONFIG_NAME, ConfigEntity.READSET_FULL);
            String content = config.getContent();
            this.m_configId = config.getId();
            this.m_modifyTime = config.getModifyDate().getTime();
            this.m_config = DefaultSaxParser.parse((String)content);
        }
        catch (DalNotFoundException e) {
            try {
                String content = this.m_fetcher.getConfigContent(CONFIG_NAME);
                Config config = this.m_configDao.createLocal();
                config.setName(CONFIG_NAME);
                config.setContent(content);
                this.m_configDao.insert(config);
                this.m_configId = config.getId();
                this.m_config = DefaultSaxParser.parse((String)content);
            }
            catch (Exception ex) {
                Cat.logError((Throwable)ex);
            }
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        if (this.m_config == null) {
            this.m_config = new ResourceConfig();
        }
        this.refreshData();
        TimerSyncTask.getInstance().register((TimerSyncTask.SyncHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public boolean insert(String xml) {
        try {
            this.m_config = DefaultSaxParser.parse((String)xml);
            return this.storeConfig();
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshConfig() throws Exception {
        Config config = this.m_configDao.findByName(CONFIG_NAME, ConfigEntity.READSET_FULL);
        long modifyTime = config.getModifyDate().getTime();
        ResourceConfigManager resourceConfigManager = this;
        synchronized (resourceConfigManager) {
            if (modifyTime > this.m_modifyTime) {
                ResourceConfig resourceConfig;
                String content = config.getContent();
                this.m_config = resourceConfig = DefaultSaxParser.parse((String)content);
                this.m_modifyTime = modifyTime;
                this.refreshData();
            }
        }
    }

    private void refreshData() {
        ConcurrentHashMap<String, ConcurrentHashMap<String, Integer>> permissions = new ConcurrentHashMap<String, ConcurrentHashMap<String, Integer>>();
        for (Resource resource : this.m_config.getResources()) {
            String path = resource.getPath();
            ConcurrentHashMap<String, Integer> pathPermission = (ConcurrentHashMap<String, Integer>)permissions.get(path);
            if (pathPermission == null) {
                pathPermission = new ConcurrentHashMap<String, Integer>();
                permissions.put(path, pathPermission);
            }
            pathPermission.put(resource.getOp(), resource.getRole());
        }
        this.m_permissions = permissions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean storeConfig() {
        ResourceConfigManager resourceConfigManager = this;
        synchronized (resourceConfigManager) {
            try {
                Config config = this.m_configDao.createLocal();
                config.setId(this.m_configId);
                config.setKeyId(this.m_configId);
                config.setName(CONFIG_NAME);
                config.setContent(this.m_config.toString());
                this.m_configDao.updateByPK(config, ConfigEntity.UPDATESET_FULL);
                this.refreshData();
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
                return false;
            }
        }
        return true;
    }

    static /* synthetic */ void access$000(ResourceConfigManager x0) throws Exception {
        x0.refreshConfig();
    }
}

