/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.system.page.permission;

import com.dianping.cat.Cat;
import com.dianping.cat.config.content.ContentFetcher;
import com.dianping.cat.core.config.Config;
import com.dianping.cat.core.config.ConfigDao;
import com.dianping.cat.core.config.ConfigEntity;
import com.dianping.cat.home.user.entity.User;
import com.dianping.cat.home.user.entity.UserConfig;
import com.dianping.cat.home.user.transform.DefaultSaxParser;
import com.dianping.cat.task.TimerSyncTask;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.unidal.dal.jdbc.DalNotFoundException;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named
public class UserConfigManager
implements Initializable {
    public static final int DEFAULT_ROLE = 1;
    private static final String CONFIG_NAME = "user-config";
    @Inject
    protected ConfigDao m_configDao;
    @Inject
    protected ContentFetcher m_fetcher;
    private int m_configId;
    private long m_modifyTime;
    private UserConfig m_config;

    public UserConfig getConfig() {
        return this.m_config;
    }

    public int getRole(String user) {
        User usr = this.m_config.findUser(user);
        if (usr != null) {
            return usr.getRole();
        }
        return 1;
    }

    public void initialize() throws InitializationException {
        try {
            Config config = this.m_configDao.findByName(CONFIG_NAME, ConfigEntity.READSET_FULL);
            String content = config.getContent();
            this.m_configId = config.getId();
            this.m_modifyTime = config.getModifyDate().getTime();
            this.m_config = DefaultSaxParser.parse((String)content);
        }
        catch (DalNotFoundException e) {
            try {
                String content = this.m_fetcher.getConfigContent(CONFIG_NAME);
                Config config = this.m_configDao.createLocal();
                config.setName(CONFIG_NAME);
                config.setContent(content);
                this.m_configDao.insert(config);
                this.m_configId = config.getId();
                this.m_config = DefaultSaxParser.parse((String)content);
            }
            catch (Exception ex) {
                Cat.logError((Throwable)ex);
            }
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        if (this.m_config == null) {
            this.m_config = new UserConfig();
        }
        TimerSyncTask.getInstance().register((TimerSyncTask.SyncHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshConfig() throws Exception {
        Config config = this.m_configDao.findByName(CONFIG_NAME, ConfigEntity.READSET_FULL);
        long modifyTime = config.getModifyDate().getTime();
        UserConfigManager userConfigManager = this;
        synchronized (userConfigManager) {
            if (modifyTime > this.m_modifyTime) {
                UserConfig userConfig;
                String content = config.getContent();
                this.m_config = userConfig = DefaultSaxParser.parse((String)content);
                this.m_modifyTime = modifyTime;
            }
        }
    }

    public boolean insert(String xml) {
        try {
            this.m_config = DefaultSaxParser.parse((String)xml);
            return this.storeConfig();
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean storeConfig() {
        UserConfigManager userConfigManager = this;
        synchronized (userConfigManager) {
            try {
                Config config = this.m_configDao.createLocal();
                config.setId(this.m_configId);
                config.setKeyId(this.m_configId);
                config.setName(CONFIG_NAME);
                config.setContent(this.m_config.toString());
                this.m_configDao.updateByPK(config, ConfigEntity.UPDATESET_FULL);
            }
            catch (Exception e) {
                Cat.logError((Throwable)e);
                return false;
            }
        }
        return true;
    }

    static /* synthetic */ void access$000(UserConfigManager x0) throws Exception {
        x0.refreshConfig();
    }
}

