/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.system.page.router;

import com.dianping.cat.Cat;
import com.dianping.cat.config.sample.SampleConfigManager;
import com.dianping.cat.config.server.ServerFilterConfigManager;
import com.dianping.cat.configuration.KVConfig;
import com.dianping.cat.configuration.property.entity.Property;
import com.dianping.cat.configuration.property.entity.PropertyConfig;
import com.dianping.cat.helper.JsonBuilder;
import com.dianping.cat.helper.TimeHelper;
import com.dianping.cat.home.router.entity.Domain;
import com.dianping.cat.home.router.entity.RouterConfig;
import com.dianping.cat.home.router.entity.Server;
import com.dianping.cat.report.task.TaskBuilder;
import com.dianping.cat.system.page.router.Action;
import com.dianping.cat.system.page.router.Context;
import com.dianping.cat.system.page.router.Handler;
import com.dianping.cat.system.page.router.Model;
import com.dianping.cat.system.page.router.Payload;
import com.dianping.cat.system.page.router.config.RouterConfigHandler;
import com.dianping.cat.system.page.router.config.RouterConfigManager;
import com.dianping.cat.system.page.router.service.CachedRouterConfigService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import org.unidal.lookup.annotation.Inject;
import org.unidal.web.mvc.PageHandler;
import org.unidal.web.mvc.annotation.InboundActionMeta;
import org.unidal.web.mvc.annotation.OutboundActionMeta;
import org.unidal.web.mvc.annotation.PayloadMeta;

public class Handler
implements PageHandler<Context> {
    @Inject
    private CachedRouterConfigService m_cachedReportService;
    @Inject
    private RouterConfigManager m_configManager;
    @Inject
    private SampleConfigManager m_sampleConfigManager;
    @Inject
    private ServerFilterConfigManager m_filterManager;
    @Inject(value={"router"})
    private TaskBuilder m_routerConfigBuilder;
    @Inject
    private RouterConfigHandler m_routerConfigHandler;
    private JsonBuilder m_jsonBuilder = new JsonBuilder();

    private String buildRouterInfo(String ip, String domain, RouterConfig config) {
        String group = this.m_configManager.queryServerGroupByIp(ip);
        Domain domainConfig = this.m_configManager.getRouterConfig().findDomain(domain);
        List servers = new ArrayList();
        if (this.domainConfigNotExist(group, domainConfig)) {
            Domain d;
            if (config != null && (d = config.findDomain(domain)) != null && d.findGroup(group) != null && (servers = d.findGroup(group).getServers()).isEmpty()) {
                Cat.logError((Throwable)new RuntimeException("Error when build router config, domain: " + domain));
            }
            if (servers.isEmpty()) {
                servers = this.m_configManager.queryServersByDomain(group, domain);
            }
        } else {
            servers = domainConfig.findGroup(group).getServers();
        }
        return this.buildServerStr(servers);
    }

    private double buildSampleInfo(String domain, double defaultValue) {
        com.dianping.cat.sample.entity.Domain domainConfig = this.m_sampleConfigManager.getConfig().findDomain(domain);
        if (domainConfig != null) {
            defaultValue = domainConfig.getSample();
        }
        return defaultValue;
    }

    private String buildServerStr(List<Server> servers) {
        StringBuilder sb = new StringBuilder();
        for (Server server : servers) {
            sb.append(server.getId()).append(":").append(server.getPort()).append(";");
        }
        return sb.toString();
    }

    private boolean domainConfigNotExist(String group, Domain domainConfig) {
        return domainConfig == null || domainConfig.findGroup(group) == null || domainConfig.findGroup(group).getServers().isEmpty();
    }

    @PayloadMeta(value=Payload.class)
    @InboundActionMeta(name="router")
    public void handleInbound(Context ctx) throws ServletException, IOException {
    }

    @OutboundActionMeta(name="router")
    public void handleOutbound(Context ctx) throws ServletException, IOException {
        Model model = new Model(ctx);
        Payload payload = (Payload)ctx.getPayload();
        Action action = payload.getAction();
        RouterConfig report = this.m_cachedReportService.queryLastRouterConfig();
        String domain = payload.getDomain();
        String ip = payload.getIp();
        switch (1.$SwitchMap$com$dianping$cat$system$page$router$Action[action.ordinal()]) {
            case 1: {
                String routerInfo = this.buildRouterInfo(ip, domain, report);
                model.setContent(routerInfo);
                break;
            }
            case 2: {
                Map kvs = this.buildKvs(report, domain, ip);
                KVConfig config = new KVConfig();
                config.getKvs().putAll(kvs);
                model.setContent(this.m_jsonBuilder.toJson((Object)config));
                break;
            }
            case 3: {
                PropertyConfig property = new PropertyConfig();
                Map kvs = this.buildKvs(report, domain, ip);
                for (Map.Entry entry : kvs.entrySet()) {
                    Property p = new Property((String)entry.getKey());
                    p.setValue((String)entry.getValue());
                    property.addProperty(p);
                }
                model.setContent(property.toString());
                break;
            }
            case 4: {
                Date period = TimeHelper.getCurrentDay((int)-1);
                boolean ret = this.m_routerConfigHandler.updateRouterConfig(period);
                model.setContent(String.valueOf(ret));
                break;
            }
            case 5: {
                if (report == null) break;
                model.setContent(report.toString());
            }
        }
        ctx.getHttpServletResponse().getWriter().write(model.getContent());
    }

    private Map<String, String> buildKvs(RouterConfig report, String domain, String ip) {
        HashMap<String, String> kvs = new HashMap<String, String>();
        kvs.put("block", String.valueOf(this.m_configManager.shouldBlock(ip)));
        kvs.put("routers", this.buildRouterInfo(ip, domain, report));
        kvs.put("sample", String.valueOf(this.buildSampleInfo(domain, 1.0)));
        kvs.put("startTransactionTypes", this.m_filterManager.getAtomicStartTypes());
        kvs.put("matchTransactionTypes", this.m_filterManager.getAtomicMatchTypes());
        return kvs;
    }
}

