/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.system.page.router.config;

import com.dianping.cat.consumer.state.model.entity.Machine;
import com.dianping.cat.consumer.state.model.transform.BaseVisitor;
import com.dianping.cat.system.page.router.config.RouterConfigManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AdjustStateReportVisitor
extends BaseVisitor {
    Map<String, Map<String, Machine>> m_datas = new HashMap();
    private RouterConfigManager m_routerConfigManager;
    private List<String> m_servers;

    public AdjustStateReportVisitor(RouterConfigManager routerConfigManager, List<String> servers) {
        this.m_routerConfigManager = routerConfigManager;
        this.m_servers = servers;
    }

    public Map<String, Map<String, Machine>> getStatistics() {
        return this.m_datas;
    }

    public void visitMachine(Machine machine) {
        String ip = machine.getIp();
        if (this.isConsumerMachine(ip)) {
            String group = this.m_routerConfigManager.queryServerGroupByIp(ip);
            HashMap<String, Machine> ms = (HashMap<String, Machine>)this.m_datas.get(group);
            if (ms == null) {
                ms = new HashMap<String, Machine>();
                this.m_datas.put(group, ms);
            }
            ms.put(ip, machine);
        }
    }

    private boolean isConsumerMachine(String ip) {
        for (String server : this.m_servers) {
            if (!server.startsWith(ip)) continue;
            return true;
        }
        return false;
    }
}

