/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.system.page.router.task;

import com.dianping.cat.config.server.ServerConfigManager;
import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.core.dal.DailyReport;
import com.dianping.cat.home.router.entity.RouterConfig;
import com.dianping.cat.home.router.transform.DefaultNativeBuilder;
import com.dianping.cat.report.task.TaskBuilder;
import com.dianping.cat.system.page.router.config.RouterConfigAdjustor;
import com.dianping.cat.system.page.router.config.RouterConfigHandler;
import com.dianping.cat.system.page.router.service.RouterConfigService;
import java.util.Date;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=TaskBuilder.class, value="router")
public class RouterConfigBuilder
implements TaskBuilder {
    public static final String ID = "router";
    @Inject
    private RouterConfigHandler m_routerConfigHandler;
    @Inject
    private RouterConfigAdjustor m_routerAdjustor;
    @Inject
    private RouterConfigService m_reportService;
    @Inject
    private ServerConfigManager m_serverConfigManager;

    public boolean buildDailyTask(String name, String domain, Date period) {
        RouterConfig routerConfig = this.m_routerConfigHandler.buildRouterConfig(domain, period);
        DailyReport dailyReport = new DailyReport();
        dailyReport.setCreationDate(new Date());
        dailyReport.setDomain(domain);
        dailyReport.setIp(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
        dailyReport.setName(name);
        dailyReport.setPeriod(period);
        dailyReport.setType(1);
        byte[] binaryContent = DefaultNativeBuilder.build((RouterConfig)routerConfig);
        this.m_reportService.insertDailyReport(dailyReport, binaryContent);
        return true;
    }

    public boolean buildHourlyTask(String name, String domain, Date period) {
        if (this.m_serverConfigManager.isRouterAdjustEnabled()) {
            this.m_routerAdjustor.Adjust(period);
        }
        return true;
    }

    public boolean buildMonthlyTask(String name, String domain, Date period) {
        throw new RuntimeException("router builder doesn't support monthly task");
    }

    public boolean buildWeeklyTask(String name, String domain, Date period) {
        throw new RuntimeException("router builder doesn't support weekly task");
    }
}

