<%@ tag trimDirectiveWhitespaces="true" pageEncoding="UTF-8"%>
<%@ taglib prefix="a" uri="/WEB-INF/app2.tld"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="w" uri="http://www.unidal.org/web/core"%>
<%@ taglib prefix="res" uri="http://www.unidal.org/webres"%>
<%@ attribute name="title"%>
<%@ attribute name="navUrlPrefix"%>
<%@ attribute name="timestamp"%>
<%@ attribute name="subtitle" fragment="true"%>

<a:application>
<script>
	function showDomain() {
		var b = $('#switch').html();
		if (b == '全部') {
			$('.domainNavbar').slideDown();
			$('#switch').html("收起");
		} else {
			$('.domainNavbar').slideUp();
			$('#switch').html("全部");
		}
	}
	function showFrequent(){
		var b = $('#frequent').html();
		if (b == '常用') {
			$('.frequentNavbar').slideDown();
			$('#frequent').html("收起");
		} else {
			$('.frequentNavbar').slideUp();
			$('#frequent').html("常用");
		}
	}
	function buildHref(domain){
		var href = '<a href="?v=2&op=${payload.action.name}&domain='+domain+'&date=${model.date}">&nbsp;[&nbsp;'+domain+'&nbsp;]&nbsp;</a>';
		return href;
	}
	$(document).ready(function() {
		var domains= getcookie('CAT_DOMAINS');
		var domainArray =domains.split("|");
		var html = '';
		var length =domainArray.length;
		
		for(var i=0;i<length;i++){
			var href = buildHref(domainArray[i])
			html+= href;
		}
		$('#frequentNavbar').html(html);
		$("#search_go").bind("click",function(e){
			var newUrl = '${model.baseUri}?v=2&op=${payload.action.name}&domain='+$( "#search" ).val() +'&date=${model.date}';
			window.location.href = newUrl;
		});
		$('#wrap_search').submit(
			function(){
				var newUrl = '${model.baseUri}?v=2&op=${payload.action.name}&domain='+$( "#search" ).val() +'&date=${model.date}';
				window.location.href = newUrl;
				return false;
			}		
		);
		
		$.widget( "custom.catcomplete", $.ui.autocomplete, {
			_renderMenu: function( ul, items ) {
				var that = this,
				currentCategory = "";
				$.each( items, function( index, item ) {
					if ( item.category != currentCategory ) {
						ul.append( "<li class='ui-autocomplete-category'>" + item.category + "</li>" );
						currentCategory = item.category;
					}
					that._renderItemData( ul, item );
				});
			}
		});
		
		var data = [];
		<c:forEach var="item" items="${model.domainGroups}">
			<c:set var="detail" value="${item.value}" />
				<c:forEach var="productline" items="${detail.projectLines}" varStatus="index">
				<c:forEach var="domain" items="${productline.value.lineDomains}">
						var item = {};
						item['label'] = '${domain}';
						item['category'] ='${productline.key}';
						
						data.push(item);
				</c:forEach>
		</c:forEach></c:forEach>
		
		$("#search").catcomplete({
			delay: 0,
			source: data
		});
	});
</script>
<style>
	.mmenu{
		background: #ffffff !important;
		height: 35px !important;
		min-height: 35px !important;
		line-height: 35px !important;
	}
	.memu{
		height: 35px;
		width: 100%;
		text-align: center;
		overflow: hidden;
		margin: 0 !important;
		padding: 0 !important;
	}
	.memu li {
		list-style-type: none;
		float: left;
		width: 100px;
		height: 35px;
		border: 1px solid gainsboro;
		margin: 0px;
		cursor: pointer;
		border-right: none;
	}
	.memu li:first-child {
		border-left: 0px solid gainsboro;
	}
	.memu li:last-child {
		border-right: 1px solid gainsboro;
	}
	.memu li.current {
		list-style-type: none;
		float: left;
		width: 100px;
		height: 35px;
		border-bottom: 0px solid gainsboro;
		border-right: none;
		background: #f5f5f5;
		color: rgb(0, 0, 238);
	}
	.memu li.current:first-child {
		border-right: 0px solid gainsboro;
	}
	.memu li.current:last-child {
		border-right: 1px solid gainsboro;
	}
	.memu li a {
		display: block;
		width: 100px;
		height: 35px;
	}
</style>
<div class="report">

	<div class="breadcrumbs mmenu">
		<ul class="memu">
			<li <c:if test="${model.page.path eq 't'}">class="current"</c:if>>
				<a href="/cat/r/t?v=2&domain=${model.domain}">服务指标</a>
			</li>
			<li <c:if test="${model.page.path eq 'p'}">class="current"</c:if>>
				<a href="/cat/r/p?v=2&domain=${model.domain}">问题排查</a>
			</li>
			<li <c:if test="${model.page.path eq 'e'}">class="current"</c:if>>
				<a href="/cat/r/e?v=2&domain=${model.domain}">事件</a>
			</li>
			<li <c:if test="${model.page.path eq 'h'}">class="current"</c:if>>
				<a href="/cat/r/h?v=2&domain=${model.domain}">JVM信息</a>
			</li>
		</ul>
	</div>

	<div class="breadcrumbs" id="breadcrumbs">
		<table>
			<tr><td><span class="text-success"><jsp:invoke fragment="subtitle"/></span></td>
				<td><div id="warp_search_group" class="" style="width:250px;">
					<form id="wrap_search" style="margin-left:10px;margin-bottom:0px;">
					<div class="input-group">
						<span class="input-group-btn "><button class="btn btn-sm btn-default" onclick="showDomain()" type="button"  id="switch">全部</button></span>
						<span class="input-group-btn "><button class="btn btn-sm btn-default" onclick="showFrequent()" type="button"  id="frequent">常用</button></span>
						<span class="input-icon" style="width:200px;">
						<input id="search" type="text" value="${model.domain}" class="search-input search-input form-control ui-autocomplete-input" placeholder="input domain for search" autocomplete="off"/>
						<i class="ace-icon fa fa-search nav-search-icon"></i>
						</span>
						<span class="input-group-btn">
							<button class="btn btn-sm btn-pink" type="button" id="search_go">
								Go
							</button> 
						</span>
					</div>
				</form>
			</div></td>
			<td><div class="nav-search nav" id="nav-search">
			<span class="text-danger switch">【<a class="switch" href="${model.baseUri}?v=2&op=history&domain=${model.domain}&ip=${model.ipAddress}"><span class="text-danger">切到历史模式</span></a>】</span>
			<c:forEach var="nav" items="${model.navs}">
					&nbsp;[ <a href="${model.baseUri}?v=2&date=${model.date}&ip=${model.ipAddress}&step=${nav.hours}&${navUrlPrefix}">${nav.title}</a> ]
				</c:forEach>
				&nbsp;[ <a href="${model.baseUri}?v=2&${navUrlPrefix}">now</a> ]&nbsp;
		</div></td>
			</tr>
		</table>
		
		<script type="text/javascript">
			try{ace.settings.check('breadcrumbs' , 'fixed')}catch(e){}
		</script>
	</div>
	<div class="domainNavbar" style="display:none;font-size:small">
		<table border="1" rules="all" >
			<c:forEach var="item" items="${model.domainGroups}">
				<tr>
					<c:set var="detail" value="${item.value}" />
					<td class="department" rowspan="${w:size(detail.projectLines)}">${item.key}</td>
					<c:forEach var="productline" items="${detail.projectLines}" varStatus="index">
							<c:if test="${index.index != 0}">
								<tr>
							</c:if>
							<td class="department">${productline.key}</td>
							<td><div class="domain"><c:forEach var="domain" items="${productline.value.lineDomains}">&nbsp;<c:choose><c:when test="${model.domain eq domain}"><a class='domainItem'
													href="?v=2&op=${payload.action.name}&domain=${domain}&date=${model.date}&reportType=${payload.reportType}"
													class="current">[&nbsp;${domain}&nbsp;]</a></c:when>
													<c:otherwise><a class='domainItem'
													href="?v=2&op=${payload.action.name}&domain=${domain}&date=${model.date}&reportType=${payload.reportType}">[&nbsp;${domain}&nbsp;]</a>
											</c:otherwise></c:choose>&nbsp;
									</c:forEach>
								</div>
							</td><c:if test="${index.index != 0}"></tr></c:if>
					</c:forEach>
				</tr>
			</c:forEach>
		</table>
	</div>
	<div class="frequentNavbar" style="display:none;font-size:small">
		<table border="1" rules="all">
			<tr>
				<td class="domain"  style="word-break:break-all" id="frequentNavbar"></td>
			<tr>
		</table>
	</div>
	<c:if test="${model.sample ne 1.0}" >
		<div class="ace-settings-container" id="ace-settings-container">
			<div class="btn btn-app btn-xs btn-warning ace-settings-btn" id="ace-settings-btn">采样</div>
	
			<div class="ace-settings-box clearfix" id="ace-settings-box">
				<div class="pull-left width-50">
					<div class="ace-settings-item">
						<label class="lbl" for="ace-settings-navbar">采样率：<strong><span class="text-danger">${w:format(model.sample*100,'#0.00')}%</span></strong></label>
					</div>
					<div class="ace-settings-item">
						<label class="lbl" for="ace-settings-navbar">采样不影响Transaction、Event的总量和QPS</label>
					</div>
					<div class="ace-settings-item">
						<label class="lbl" for="ace-settings-navbar">并不适用于Metric、Heartbeat、Exception三项指标</label>
					</div>
				</div>
			</div>
		</div>
	</c:if>
	<jsp:doBody />
</div>
</a:application>