/*
 * Decompiled with CFR 0.152.
 */
package com.asiainfo.openplatform.common.util;

import com.asiainfo.openplatform.common.util.AESUtil;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.NoSuchPaddingException;

public class AESFactory {
    private static Map<String, AESUtil> tools = new HashMap<String, AESUtil>();

    private AESFactory() {
    }

    public static AESUtil createAesGenerator(AESUtil.CipherMode cipherMode, AESUtil.PaddingMode paddingMode, String key, String iv, boolean simple) throws NoSuchAlgorithmException, NoSuchPaddingException, UnsupportedEncodingException {
        String toolKey = String.valueOf(AESUtil.getAlogrithm()) + "/" + (cipherMode == null ? "" : cipherMode.getCode()) + "/" + (paddingMode == null ? "" : paddingMode.getPadding()) + "/" + key + "/" + iv;
        if (tools.containsKey(toolKey)) {
            return tools.get(toolKey);
        }
        AESUtil generator = new AESUtil(cipherMode, paddingMode, key, iv, simple);
        tools.put(toolKey, generator);
        return generator;
    }

    public static AESUtil createAesGenerator(AESUtil.CipherMode cipherMode, AESUtil.PaddingMode paddingMode, String key, String iv) throws NoSuchAlgorithmException, NoSuchPaddingException, UnsupportedEncodingException {
        return AESFactory.createAesGenerator(cipherMode, paddingMode, key, iv, false);
    }

    public static AESUtil createXxxAesGenerator(String key, String iv) throws NoSuchAlgorithmException, NoSuchPaddingException, UnsupportedEncodingException {
        return AESFactory.createAesGenerator(AESUtil.CipherMode.CBC, AESUtil.PaddingMode.Nopadding, key, iv);
    }

    public static AESUtil createSimpleAesGenerator(String key) throws NoSuchAlgorithmException, NoSuchPaddingException, UnsupportedEncodingException {
        return AESFactory.createAesGenerator(null, null, key, null, true);
    }
}

