/*
 * Decompiled with CFR 0.152.
 */
package com.asiainfo.openplatform.common.util;

import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class AESUtil {
    private static final String UTF_8 = "UTF-8";
    private static final String alogrithm = "AES";
    private CipherMode cipherMode;
    private PaddingMode paddingMode;
    private SecretKeySpec skeySpec;
    private IvParameterSpec ivParamSpec;
    private Cipher cipher;
    private String AES_CIPHER_PADDING_MODE;
    private boolean simple;

    public AESUtil(CipherMode cipherMode, PaddingMode paddingMode, String key, String iv, boolean simple) throws NoSuchAlgorithmException, NoSuchPaddingException, UnsupportedEncodingException {
        if (simple) {
            this.simple = simple;
            KeyGenerator keyGenerator = KeyGenerator.getInstance(alogrithm, (Provider)new BouncyCastleProvider());
            keyGenerator.init(128, new SecureRandom(key.getBytes()));
            SecretKey secretKey = keyGenerator.generateKey();
            byte[] raw = secretKey.getEncoded();
            this.skeySpec = new SecretKeySpec(raw, alogrithm);
            this.cipher = Cipher.getInstance(alogrithm, (Provider)new BouncyCastleProvider());
        } else {
            if (cipherMode == null || paddingMode == null) {
                throw new UnsupportedOperationException("CipherMode and PaddingMode must not be null");
            }
            this.cipherMode = cipherMode;
            this.paddingMode = paddingMode;
            byte[] raw = AESUtil.hexStringToBytes(AESUtil.getMD5Str(key));
            this.skeySpec = new SecretKeySpec(raw, alogrithm);
            this.AES_CIPHER_PADDING_MODE = "AES/" + cipherMode.getCode() + "/" + paddingMode.getPadding();
            this.cipher = Cipher.getInstance(this.AES_CIPHER_PADDING_MODE, (Provider)new BouncyCastleProvider());
            if (!this.cipherMode.equals((Object)CipherMode.ECB)) {
                this.ivParamSpec = new IvParameterSpec(AESUtil.hexStringToBytes(AESUtil.getMD5Str(iv)));
            }
        }
    }

    public AESUtil(CipherMode cipherMode, PaddingMode paddingMode, String key, String iv) throws NoSuchAlgorithmException, NoSuchPaddingException, UnsupportedEncodingException {
        this(cipherMode, paddingMode, key, iv, false);
    }

    public String encrypt(String source) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException, InvalidAlgorithmParameterException {
        if (this.simple) {
            this.cipher.init(1, this.skeySpec);
        } else {
            int len;
            int m;
            if (this.cipherMode.equals((Object)CipherMode.ECB)) {
                this.cipher.init(1, this.skeySpec);
            } else {
                this.cipher.init(1, (Key)this.skeySpec, this.ivParamSpec);
            }
            if (this.paddingMode.equals((Object)PaddingMode.Nopadding) && (m = (len = source.getBytes(UTF_8).length) % 16) != 0) {
                int i = 0;
                while (i < 16 - m) {
                    source = String.valueOf(source) + " ";
                    ++i;
                }
            }
        }
        byte[] encrypted = this.cipher.doFinal(source.getBytes(UTF_8));
        return AESUtil.bytesToHexString(encrypted);
    }

    public String decrypt(String source) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        if (this.simple || this.cipherMode.equals((Object)CipherMode.ECB)) {
            this.cipher.init(2, this.skeySpec);
        } else {
            this.cipher.init(2, (Key)this.skeySpec, this.ivParamSpec);
        }
        byte[] encrypted1 = AESUtil.hexStringToBytes(source);
        byte[] original = this.cipher.doFinal(encrypted1);
        return new String(original, UTF_8);
    }

    public static byte[] hexStringToBytes(String hexString) {
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        int i = 0;
        while (i < length) {
            int pos = i * 2;
            d[i] = (byte)(AESUtil.charToByte(hexChars[pos]) << 4 | AESUtil.charToByte(hexChars[pos + 1]));
            ++i;
        }
        return d;
    }

    public static String bytesToHexString(byte[] b) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < b.length) {
            String hex = Integer.toHexString(b[i] & 0xFF);
            if (hex.length() == 1) {
                hex = String.valueOf('0') + hex;
            }
            sb.append(hex);
            ++i;
        }
        return sb.toString();
    }

    private static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public static String getMD5Str(String strIn) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        messageDigest.reset();
        messageDigest.update(strIn.getBytes(UTF_8));
        byte[] byteArray = messageDigest.digest();
        return AESUtil.bytesToHexString(byteArray);
    }

    public static String getAlogrithm() {
        return alogrithm;
    }

    public CipherMode getCipherMode() {
        return this.cipherMode;
    }

    public PaddingMode getPaddingMode() {
        return this.paddingMode;
    }

    public static enum CipherMode {
        CBC("CBC"),
        ECB("ECB"),
        CTR("CTR"),
        OCB("OCB"),
        CFB("CFB");

        private String code;

        private CipherMode(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }
    }

    public static enum PaddingMode {
        Nopadding("Nopadding"),
        PKCS5Padding("PKCS5Padding"),
        ISO10126Padding("ISO10126Padding");

        private String padding;

        private PaddingMode(String padding) {
            this.padding = padding;
        }

        public String getPadding() {
            return this.padding;
        }
    }
}

