/*
 * Decompiled with CFR 0.152.
 */
package com.asiainfo.openplatform.common.util;

import com.asiainfo.openplatform.common.util.MD5Util;
import com.asiainfo.openplatform.common.util.RSAUtils;
import com.asiainfo.openplatform.common.util.SecurityUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class SignUtil {
    private static final String SIGN_METHOD_RSAWITHMD5 = "RSAWithMD5";
    private static final String SIGN_METHOD_HMACSHA256 = "HmacSHA256";

    private static String signWithRSA(Map<String, String> sysParam, String busiParam, String publicKey) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>(sysParam);
        map.put("content", busiParam);
        Object[] keys = map.keySet().toArray(new String[map.size()]);
        Arrays.sort(keys);
        StringBuilder buf = new StringBuilder(200);
        Object[] objectArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            Object key = objectArray[n2];
            if (!"sign".equalsIgnoreCase((String)key)) {
                buf.append((String)map.get(key));
            }
            ++n2;
        }
        String encrypt_value = "";
        if (buf.toString().length() > 0) {
            encrypt_value = MD5Util.MD5(buf.toString());
            System.out.println(encrypt_value);
        }
        return RSAUtils.encryptByPublicKey(encrypt_value, publicKey);
    }

    private static String signWithSHA256(Map<String, String> sysParam, String busiParam, String key) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>(sysParam);
        map.put("content", busiParam);
        Object[] keys = map.keySet().toArray(new String[map.size()]);
        Arrays.sort(keys);
        StringBuilder buf = new StringBuilder(200);
        buf.append(key);
        Object[] objectArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            Object k = objectArray[n2];
            if (!"sign".equalsIgnoreCase((String)k)) {
                buf.append((String)k).append((String)map.get(k));
            }
            ++n2;
        }
        buf.append(key);
        System.out.println("signStr=" + buf.toString());
        return SecurityUtils.encodeHmacSHA256HexUpper(buf.toString(), SecurityUtils.decodeHexUpper(key));
    }

    public static String sign(Map<String, String> sysParam, String busiParam, String method, String key) throws Exception {
        if (!(sysParam != null && !sysParam.isEmpty() || busiParam != null && busiParam.trim().length() != 0)) {
            return null;
        }
        if (SIGN_METHOD_HMACSHA256.equals(method)) {
            return SignUtil.signWithSHA256(sysParam, busiParam, key);
        }
        if (SIGN_METHOD_RSAWITHMD5.equals(method)) {
            return SignUtil.signWithRSA(sysParam, busiParam, key);
        }
        throw new Exception("\u5bf9\u4e0d\u8d77\uff0c\u6682\u4e0d\u652f\u6301[" + method + "]\u7b7e\u540d\u65b9\u6cd5\uff01");
    }

    public static String sign(Map<String, String> sysParam, String busiParam, String publicKey) throws Exception {
        if (!(sysParam != null && !sysParam.isEmpty() || busiParam != null && busiParam.trim().length() != 0)) {
            return null;
        }
        return SignUtil.signWithRSA(sysParam, busiParam, publicKey);
    }

    public static void main(String[] args) {
        String busiParam = "{\"BILL_ID\":\"13460110000\"}";
        String key = "92c7115224f76ed30922954eda56cbe0";
        HashMap<String, String> sysParam = new HashMap<String, String>();
        sysParam.put("method", "SO_MEMBER_DEAL_QUERY");
        sysParam.put("format", "json");
        sysParam.put("timestamp", "20150907134424");
        sysParam.put("appId", "501571");
        sysParam.put("version", "1.0");
        sysParam.put("busiSerial", "0907134424");
        sysParam.put("accessToken", "d7ccb7f3-a081-45bd-ab5b-f8fcbae10d7e");
        try {
            System.out.println(busiParam);
            System.out.println(key);
            String sign = SignUtil.sign(sysParam, busiParam, SIGN_METHOD_HMACSHA256, key);
            System.out.println(sign);
        }
        catch (Exception e) {
            System.out.println("error");
            e.printStackTrace();
        }
    }
}

