package com.duiba.tuia.abtest.api.dto;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 实验计划表
 *
 * @author YWG.TOP.SONG
 * @email xuesong@tuia.com.cn
 * @date 2020-08-26 14:31:56
 */
@Data
@ApiModel
public class TestPlanDTO implements Serializable {

    @ApiModelProperty("实验计划id")
    private Long id;
    /**
     * 实验名称
     */
    @ApiModelProperty("实验名称")
    private String testPlanName;
    /**
     * 操作人id
     */
    private Long adminId;
    /**
     * 测试状态:0未开始,1进行中,2已结束,3-空跑中
     */
    private Integer testStatus;
    /**
     * 开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    @ApiModelProperty("开始时间")
    private Date startTime;
    /**
     * 结束时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    @ApiModelProperty("结束时间")
    private Date endTime;
    /**
     * 实验描述
     */
    private String testPlanDesc;
    /**
     * 对应的测试层,测试组
     */
    private Map<String, List<TestPlanGroupDTO>> testPlanGroups;

    private Date gmtCreate;

    private Date gmtModified;

    private List<TestConditionDTO> conditionValues;


    /**
     * 对应的白名单Map
     */
    private List<UserWhiteListDO> whiteLists;

    //-------前端需要-------//

    @ApiModelProperty("创建人")
    private String adminName;

    @ApiModelProperty("相关人员name,逗号分隔")
    private String relatedNames;

    @ApiModelProperty("相关人员id集合,逗号分隔")
    private String relatedIds;

    @ApiModelProperty("分流方式:0-UV分流,1-PV分流")
    private Integer splitType;

    private String layerName;

    @ApiModelProperty("实验场景id 1-素材 2-活动 3-广告 4-广告算法")
    private Integer testTypeId;

    private Long conditionGroupId;

    @ApiModelProperty("当前测试天数,空跑统计最近一次空跑天数,测试中统计最近一次测试天数")
    private Double testDays;

    @ApiModelProperty("空跑状态: 0-不空跑 1-空跑中 2-空跑结束")
    private Integer dryRunStatus;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    @ApiModelProperty("空跑结束结束时间")
    private Date dryRunEndDate;

    /**
     * 域id
     */
    private Long domainId;

    /**
     * 域类型
     */
    private Integer domainType;


    @ApiModelProperty("预警白名单设置状态: 0-未设置 1-已设置")
    private Integer warnSettingStatus;

    @ApiModelProperty("空跑设置状态:0-不需要空跑,1-前置空跑,2-后置空跑")
    private Integer dryRunSetStatus;

}
