package com.duiba.tuia.abtest.api.sdk;

import com.duiba.tuia.abtest.api.dto.ABAdvertResponseBatchDto;
import com.duiba.tuia.abtest.api.dto.ABAdvertResponseDto;
import com.duiba.tuia.abtest.api.dto.ABRequestDto;
import com.duiba.tuia.abtest.api.dto.ABResponseDto;

import java.util.List;

/**
 * 业务系统执行ABTest相关接口
 */
public interface ABTest {
    /**
     * 执行ABTest
     *
     * @param request 输入参数
     * @return 实验结果
     */
    ABResponseDto run(ABRequestDto request);


    /**
     * @Description  广告定制run接口(支持批量传层编号)
     * @Param [request]
     * @return com.duiba.tuia.abtest.api.dto.ABAdvertResponseDto
     **/
    ABAdvertResponseDto advertRun(ABRequestDto request);


    /**
     * @Description  广告定制run接口(支持批量传层编号)
     * @Param [request]
     * @return com.duiba.tuia.abtest.api.dto.ABAdvertResponseDto
     **/
    ABAdvertResponseDto advertRunWithRemote(ABRequestDto request);

    /**
     * @Description  广告实验分流对接接口,批量广告计划
     * @Param [request]
     * @return com.duiba.tuia.abtest.api.dto.ABAdvertResponseDto
     **/
    ABAdvertResponseBatchDto advertRunBatch(List<ABRequestDto> request);

}
