package com.duiba.tuia.abtest.api.dto;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import com.duiba.tuia.abtest.api.dto.TestSlotPlanDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 测试广告位
 *
 * @author YWG.TOP.SONG
 * @email xuesong@tuia.com.cn
 * @date 2020-08-26 14:31:56
 */
@Data
@ApiModel
public class TestSlotDTO implements Serializable {

    private Long id;

    /**
     * 广告位id
     */
    @ApiModelProperty("广告位id")
    private Long slotId;

    @ApiModelProperty("广告位名")
    private String slotName;

    @ApiModelProperty("媒体id")
    private Long appId;

    @ApiModelProperty("媒体名")
    private String appName;

    private Integer slotType;

    private String slotTypeStr;

    @ApiModelProperty("广告位访问uv")
    private Long totalUv;

    private Long predictUv;

    private Integer testRatio;

    private String managerName;

    /**
     * 广告位对应的实验计划
     */
    @ApiModelProperty("广告位对应的实验计划")
    List<TestSlotPlanDTO> testPlans;

    private Date gmtCreate;
    /**
     *
     */
    private Date gmtModified;

    private String testLayerCode;

    /**
     * 实验总量级
     */
    @ApiModelProperty("实验总量级")
    private Long planTotalOrder = 0L;

    /**
     * 实验已用量级
     */
    @ApiModelProperty("实验已用量级")
    private Long planUseOrder;

    /**
     * 实验可用用量级
     */
    @ApiModelProperty("实验可用量级")
    private Long planValidOrder;

    /**
     * 进行中的实验数
     */
    @ApiModelProperty("进行中的实验数")
    private Integer testPlanCount;

    /**
     * 0未选择,1已选中
     * */
    private Integer isSelected = 0;

    /**
     * 是否发生改变：1可用比例发生变化,0未变化
     * */
    private Integer isExchange = 0;

    /** 广告id,在这里冗余一个字段,用通用对象去接 **/
    private Long advertId;
    /**
     * 昨日量级
     */
    private Long requestUv = 0L;
    /**
     * 前天量级
     */
    private Long request1dayAgoUv = 0L;

    /**
     * 大前天量级
     */
    private Long request2dayAgoUv = 0L;

    private boolean fluctuateWarning = false;

}
