package com.duiba.tuia.abtest.api.advertreq;

import lombok.Data;

import java.util.Date;
import java.util.List;


/**
 *
 * 创建实验入参
 *
 * */
@Data
public class AdvertTestPlanReq {

    /** 计划ID,编辑时传 **/
    private Long planId;

    /** 实验计划名称 **/
    private String testPlanName;

    /** 开始时间 **/
    private Date startTime;

    /** 结束时间 **/
    private Date endTime;

    /** 描述信息 **/
    private String testPlanDesc;

    /** 广告计划流量比例,当前只会传一个广告计划过来,预留List以便后面扩展 **/
    private List<TestAdvertReq> advert;

    /** 实验组集合,对应 落地页链接 或者 券 List **/
    private List<TestPlanGroupReq> testGroups;

    /** 受众集合,对应配置的list **/
    private List<TestConditionReq> conditionValueList;

    /**
     * 受众分组id
     * */
    private Long conditionGroupId;

    /** 关联用户id,逗号分隔 **/
    private Long adminId;

    /** 是否域:0-不是,1:券+落地页域 **/
    private Integer isDomain;

    /** 相关人员id集合,逗号分隔 **/
    private String relatedIds;
}
