/*
 * Decompiled with CFR 0.152.
 */
package com.duiba.tuia.abtest.api.sdk.core;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.duiba.tuia.abtest.api.dto.ABAdvertResponseBatchDto;
import com.duiba.tuia.abtest.api.dto.ABAdvertResponseDto;
import com.duiba.tuia.abtest.api.dto.ABCacheRequestDto;
import com.duiba.tuia.abtest.api.dto.ABRequestDto;
import com.duiba.tuia.abtest.api.dto.ABResponseDto;
import com.duiba.tuia.abtest.api.dto.ABResultDto;
import com.duiba.tuia.abtest.api.dto.PlanLogDTO;
import com.duiba.tuia.abtest.api.dto.TestConditionDTO;
import com.duiba.tuia.abtest.api.dto.TestPlanDTO;
import com.duiba.tuia.abtest.api.dto.TestPlanGroupDTO;
import com.duiba.tuia.abtest.api.dto.TestSlotDTO;
import com.duiba.tuia.abtest.api.dto.TestSlotPlanDTO;
import com.duiba.tuia.abtest.api.dto.UserWhiteListDO;
import com.duiba.tuia.abtest.api.remoteservice.RemoteABTestService;
import com.duiba.tuia.abtest.api.sdk.ABTest;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class ABTestV1
implements ABTest {
    @Value(value="${abtest.log.time.milliseconds:100}")
    private Integer LOG_TIME;
    @Value(value="${abtest.cache.refresh.seconds:5}")
    private Integer CACHE_REFRESH_MILLS;
    @Value(value="${abtest.cache.expire.seconds:60}")
    private Integer CACHE_EXPIRE_MILLS;
    private static Random random = new Random();
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ExecutorService executorService;
    private LoadingCache<Long, TestSlotDTO> testPlanCache;
    private LoadingCache<Long, TestSlotDTO> advertTestPlanCache;
    private LoadingCache<String, TestSlotDTO> advertAlgoPlanCache;
    @Resource
    private RemoteABTestService remoteABTestService;
    private final CacheLoader cacheLoader = new CacheLoader<Long, TestSlotDTO>(){

        public TestSlotDTO load(Long slotId) throws Exception {
            return ABTestV1.this.remoteABTestService.getSlotCache(slotId);
        }

        public ListenableFuture<TestSlotDTO> reload(Long key, TestSlotDTO oldValue) throws Exception {
            ListenableFutureTask task = ListenableFutureTask.create(() -> {
                try {
                    return this.load(key);
                }
                catch (Exception e) {
                    return oldValue;
                }
            });
            ABTestV1.this.executorService.submit((Runnable)task);
            return task;
        }
    };
    private final CacheLoader advertCacheLoader = new CacheLoader<Long, TestSlotDTO>(){

        public TestSlotDTO load(Long advertId) throws Exception {
            ABCacheRequestDto cacheRequestDto = new ABCacheRequestDto();
            cacheRequestDto.setAdvertId(advertId);
            return ABTestV1.this.remoteABTestService.getAdvertCache(cacheRequestDto);
        }

        public ListenableFuture<TestSlotDTO> reload(Long key, TestSlotDTO oldValue) throws Exception {
            ListenableFutureTask task = ListenableFutureTask.create(() -> {
                try {
                    return this.load(key);
                }
                catch (Exception e) {
                    return oldValue;
                }
            });
            ABTestV1.this.executorService.submit((Runnable)task);
            return task;
        }
    };
    private final CacheLoader advertAlgoCacheLoader = new CacheLoader<String, TestSlotDTO>(){

        public TestSlotDTO load(String layerCode) throws Exception {
            return ABTestV1.this.remoteABTestService.getAdvertAlgoCache(layerCode);
        }

        public ListenableFuture<TestSlotDTO> reload(String key, TestSlotDTO oldValue) throws Exception {
            ListenableFutureTask task = ListenableFutureTask.create(() -> {
                try {
                    return this.load(key);
                }
                catch (Exception e) {
                    return oldValue;
                }
            });
            ABTestV1.this.executorService.submit((Runnable)task);
            return task;
        }
    };
    LinkedBlockingDeque<JSONObject> queue = new LinkedBlockingDeque();

    @PostConstruct
    public void init() {
        this.testPlanCache = CacheBuilder.newBuilder().initialCapacity(100).maximumSize(5000L).refreshAfterWrite((long)this.CACHE_REFRESH_MILLS.intValue(), TimeUnit.SECONDS).expireAfterWrite((long)this.CACHE_EXPIRE_MILLS.intValue(), TimeUnit.SECONDS).build(this.cacheLoader);
        this.advertTestPlanCache = CacheBuilder.newBuilder().initialCapacity(100).maximumSize(5000L).refreshAfterWrite((long)this.CACHE_REFRESH_MILLS.intValue(), TimeUnit.MILLISECONDS).expireAfterWrite((long)this.CACHE_EXPIRE_MILLS.intValue(), TimeUnit.SECONDS).build(this.advertCacheLoader);
        this.advertAlgoPlanCache = CacheBuilder.newBuilder().initialCapacity(100).maximumSize(5000L).refreshAfterWrite((long)this.CACHE_REFRESH_MILLS.intValue(), TimeUnit.MILLISECONDS).expireAfterWrite((long)this.CACHE_EXPIRE_MILLS.intValue(), TimeUnit.SECONDS).build(this.advertAlgoCacheLoader);
        ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1);
        executorService.scheduleAtFixedRate(() -> {
            int size = this.queue.size();
            if (size == 0) {
                return;
            }
            ArrayList<JSONObject> requestTests = new ArrayList<JSONObject>();
            for (int i = 0; i < size; ++i) {
                JSONObject poll = this.queue.poll();
                requestTests.add(poll);
            }
            this.logger.info("\u65e5\u5fd7\u5408\u5e76\u4e86" + requestTests.size() + "\u6761\uff01");
        }, 0L, this.LOG_TIME.intValue(), TimeUnit.MILLISECONDS);
    }

    @Override
    @Deprecated
    public ABResponseDto run(ABRequestDto request) {
        TestSlotDTO slotPlan = null;
        try {
            slotPlan = (TestSlotDTO)this.testPlanCache.get((Object)request.getSlotId());
        }
        catch (ExecutionException e) {
            slotPlan = this.NullObject(request.getSlotId());
            this.logger.warn("\u5f02\u5e38\u8fd4\u56de\u7a7a\u5bf9\u8c61:[{}]", (Throwable)e);
        }
        List<TestSlotPlanDTO> testPlans = this.filter(request.getExtra(), request.getLayerCode(), slotPlan);
        if (testPlans.isEmpty()) {
            this.setInnerLog(request);
            return new ABResponseDto(false, "\u6ca1\u6709\u5b9e\u9a8c");
        }
        UserWhiteListDO userWhiteListDO = this.filterWithWhiteList(testPlans, request.getDeviceId());
        if (Objects.nonNull(userWhiteListDO)) {
            ABResultDto result;
            TestSlotPlanDTO testPlan = new TestSlotPlanDTO();
            for (TestSlotPlanDTO testSlotPlanDTO : testPlans) {
                if (!Objects.equals(testSlotPlanDTO.getPlanId(), userWhiteListDO.getPlanId())) continue;
                testPlan = testSlotPlanDTO;
            }
            TestPlanGroupDTO current = new TestPlanGroupDTO();
            List<TestPlanGroupDTO> testPlanGroupDTOS = testPlan.getTestPlan().getTestPlanGroups().get(request.getLayerCode());
            for (TestPlanGroupDTO testPlanGroupDTO : testPlanGroupDTOS) {
                if (!Objects.equals(testPlanGroupDTO.getGroupId(), userWhiteListDO.getGroupId())) continue;
                current = testPlanGroupDTO;
            }
            if (current != null) {
                result = new ABResultDto(true);
                result.setLayerCode(current.getTestLayerCode());
                result.setGroupId(current.getGroupId());
                result.setGroupName(current.getGroupName());
                result.setTestType(current.getTestType());
                result.setTestValue(current.getTestValue());
                result.setPlanId(testPlan.getPlanId());
            } else {
                result = new ABResultDto(false, request.getLayerCode(), "\u6ca1\u6709\u5206\u6d41\u5230\u6d4b\u8bd5\u7ec4");
            }
            ArrayList<ABResultDto> results = new ArrayList<ABResultDto>();
            results.add(result);
            this.setInnerLog(testPlan, results, request);
            return new ABResponseDto(true, testPlan.getPlanId(), results);
        }
        TestSlotPlanDTO plan = this.domainHash(testPlans, request, false, 0);
        if (plan == null) {
            this.setInnerLog(request);
            return new ABResponseDto(false, "\u6ca1\u6709\u5206\u6d41\u5230\u5b9e\u9a8c");
        }
        List<ABResultDto> layerResult = this.layerHash(plan, request, false, false);
        this.setInnerLog(plan, layerResult, request);
        return new ABResponseDto(true, plan.getPlanId(), layerResult);
    }

    @Override
    @Deprecated
    public ABAdvertResponseDto advertRun(ABRequestDto request) {
        List<String> layerCodes = Arrays.asList(request.getLayerCode().split(","));
        HashMap<String, ABResultDto> total = new HashMap<String, ABResultDto>();
        layerCodes.forEach(layerCode -> {
            TestSlotDTO slotPlan;
            Boolean isDomain = false;
            Integer domainPercent = 0;
            request.setLayerCode((String)layerCode);
            List<Object> testPlans = new ArrayList();
            if (Objects.nonNull(request.getAdvertId())) {
                slotPlan = null;
                try {
                    slotPlan = (TestSlotDTO)this.advertTestPlanCache.get((Object)request.getAdvertId());
                }
                catch (ExecutionException e) {
                    slotPlan = this.NullObject(request.getSlotId());
                    this.logger.warn("\u5f02\u5e38\u8fd4\u56de\u7a7a\u5bf9\u8c61:[{}]", (Throwable)e);
                }
                testPlans = this.filter(request.getExtra(), request.getLayerCode(), slotPlan);
                isDomain = this.isDomainHash(testPlans, request);
                domainPercent = this.getDomainPercent(testPlans);
                if (!isDomain.booleanValue()) {
                    testPlans = this.filterNotDomainPlans(testPlans);
                }
            } else {
                slotPlan = null;
                try {
                    slotPlan = (TestSlotDTO)this.advertAlgoPlanCache.get((Object)request.getLayerCode());
                }
                catch (ExecutionException e) {
                    slotPlan = this.NullObject(request.getLayerCode());
                    this.logger.warn("\u5f02\u5e38\u8fd4\u56de\u7a7a\u5bf9\u8c61:[{}]", (Throwable)e);
                }
                testPlans = this.filter(request.getExtra(), request.getLayerCode(), slotPlan);
            }
            if (testPlans.isEmpty()) {
                this.setInnerLog(request);
                return;
            }
            TestSlotPlanDTO plan = this.domainHash(testPlans, request, isDomain, domainPercent);
            if (plan == null) {
                this.setInnerLog(request);
                return;
            }
            List<ABResultDto> layerResult = this.layerHash(plan, request, true, isDomain);
            if (!layerResult.get(0).isSuccess()) {
                this.setInnerLog(plan, layerResult, request);
                return;
            }
            this.setInnerLog(plan, layerResult, request);
            total.put(layerResult.get(0).getLayerCode(), layerResult.get(0));
        });
        if (total.isEmpty()) {
            return new ABAdvertResponseDto(false, "\u6ca1\u6709\u8bd5\u9a8c");
        }
        return new ABAdvertResponseDto(true, total);
    }

    @Override
    @Deprecated
    public ABAdvertResponseDto advertRunWithRemote(ABRequestDto request) {
        return this.remoteABTestService.advertRun(request);
    }

    @Override
    @Deprecated
    public ABAdvertResponseBatchDto advertRunBatch(List<ABRequestDto> requests) {
        ArrayList<ABResultDto> total = new ArrayList<ABResultDto>();
        requests.forEach(request -> {
            TestSlotPlanDTO plan;
            TestSlotDTO slotPlan = null;
            try {
                slotPlan = (TestSlotDTO)this.advertTestPlanCache.get((Object)request.getAdvertId());
            }
            catch (ExecutionException e) {
                slotPlan = this.NullObject(request.getAdvertId());
                this.logger.warn("\u5f02\u5e38\u8fd4\u56de\u7a7a\u5bf9\u8c61:[{}]", (Throwable)e);
            }
            List<TestSlotPlanDTO> testPlans = this.filter(request.getExtra(), request.getLayerCode(), slotPlan);
            if (testPlans.isEmpty()) {
                this.setInnerLog((ABRequestDto)request);
                return;
            }
            Boolean isDomain = this.isDomainHash(testPlans, (ABRequestDto)request);
            Integer domainPercent = this.getDomainPercent(testPlans);
            if (!isDomain.booleanValue()) {
                testPlans = this.filterNotDomainPlans(testPlans);
            }
            if ((plan = this.domainHash(testPlans, (ABRequestDto)request, isDomain, domainPercent)) == null) {
                this.setInnerLog((ABRequestDto)request);
                return;
            }
            List<ABResultDto> layerResult = this.layerHash(plan, (ABRequestDto)request, true, isDomain);
            if (!layerResult.get(0).isSuccess()) {
                this.setInnerLog(plan, layerResult, (ABRequestDto)request);
                return;
            }
            this.setInnerLog(plan, layerResult, (ABRequestDto)request);
            layerResult.get(0).setExtra(request.getExtra());
            total.add(layerResult.get(0));
        });
        if (CollectionUtils.isEmpty(total)) {
            return new ABAdvertResponseBatchDto(false, "\u6ca1\u6709\u8bd5\u9a8c");
        }
        return new ABAdvertResponseBatchDto(true, total);
    }

    private TestSlotPlanDTO domainHash(List<TestSlotPlanDTO> testPlans, ABRequestDto request, Boolean isDomain, Integer domainPercent) {
        int domainHash = 0;
        domainHash = isDomain != false ? this.hash(request.getDeviceId()) % 100 : (Objects.equals(testPlans.get(0).getTestPlan().getSplitType(), 1) ? random.nextInt(100 - domainPercent) : this.hash(request.getDeviceId() + request.getSlotId() + request.getLayerCode()) % (100 - domainPercent));
        TestSlotPlanDTO current = null;
        for (TestSlotPlanDTO slotPlan : testPlans) {
            if (!slotPlan.getPercentDistrictSet().contains(domainHash)) continue;
            current = slotPlan;
            break;
        }
        return current;
    }

    private List<ABResultDto> layerHash(TestSlotPlanDTO planDTO, ABRequestDto request, boolean isAdvert, Boolean isDomain) {
        ABResultDto result;
        int layerHash = 0;
        layerHash = isDomain != false ? this.hash(request.getDeviceId() + planDTO.getPlanId()) % 100 : (Objects.equals(planDTO.getTestPlan().getSplitType(), 1) ? random.nextInt(100) : (isAdvert ? this.hash(request.getDeviceId() + request.getLayerCode() + planDTO.getPlanId()) % 100 : this.hash(request.getDeviceId() + request.getSlotId() + request.getLayerCode() + planDTO.getPlanId()) % 100));
        List<TestPlanGroupDTO> groups = planDTO.getTestPlan().getTestPlanGroups().get(request.getLayerCode());
        TestPlanGroupDTO current = null;
        for (TestPlanGroupDTO group : groups) {
            if (!group.getPercentDistrictSet().contains(layerHash)) continue;
            current = group;
            break;
        }
        if (current != null) {
            result = new ABResultDto(true);
            result.setLayerCode(current.getTestLayerCode());
            result.setGroupId(current.getGroupId());
            result.setGroupName(current.getGroupName());
            result.setTestType(current.getTestType());
            result.setTestValue(current.getTestValue());
            result.setPlanId(planDTO.getPlanId());
            result.setDomainStatus(isDomain != false ? 1 : 0);
        } else {
            result = new ABResultDto(false, request.getLayerCode(), "\u6ca1\u6709\u5206\u6d41\u5230\u6d4b\u8bd5\u7ec4 hash:" + layerHash);
        }
        ArrayList<ABResultDto> results = new ArrayList<ABResultDto>();
        results.add(result);
        return results;
    }

    private int hash(String str) {
        String HashStr = DigestUtils.md5Hex((String)str);
        int hash = HashStr.length();
        for (int i = 0; i < HashStr.length(); ++i) {
            hash = hash << 5 ^ hash >> 27 ^ HashStr.charAt(i);
        }
        int hashCode = hash & Integer.MAX_VALUE;
        return hashCode < 0 ? -hashCode : hashCode;
    }

    private UserWhiteListDO filterWithWhiteList(List<TestSlotPlanDTO> testPlans, String deviceId) {
        for (TestSlotPlanDTO testPlan : testPlans) {
            if (Objects.isNull(testPlan.getTestPlan()) || CollectionUtils.isEmpty(testPlan.getTestPlan().getWhiteLists())) continue;
            List<UserWhiteListDO> whiteLists = testPlan.getTestPlan().getWhiteLists();
            for (UserWhiteListDO whiteList : whiteLists) {
                if (!Objects.equals(whiteList.getDeviceId(), deviceId)) continue;
                return whiteList;
            }
        }
        return null;
    }

    private void setInnerLog(ABRequestDto request) {
        JSONObject json = new JSONObject();
        json.put("device_id", (Object)request.getDeviceId());
        json.put("slot_id", (Object)request.getSlotId());
        json.put("advert_id", (Object)request.getAdvertId());
        if (StringUtils.isNotBlank((CharSequence)request.getRid())) {
            json.put("rid", (Object)request.getRid());
        }
        ArrayList<PlanLogDTO> list = new ArrayList<PlanLogDTO>();
        PlanLogDTO planLog = new PlanLogDTO();
        planLog.setLayer_code(request.getLayerCode());
        planLog.setIs_hit(0);
        list.add(planLog);
        json.put("plan", (Object)JSON.toJSONString(list));
        this.queue.add(json);
    }

    private void setInnerLog(TestSlotPlanDTO plan, List<ABResultDto> layerResult, ABRequestDto request) {
        JSONObject json = new JSONObject();
        json.put("device_id", (Object)request.getDeviceId());
        json.put("slot_id", (Object)request.getSlotId());
        json.put("advert_id", (Object)request.getAdvertId());
        json.put("plan_id", (Object)plan.getPlanId());
        ArrayList list = new ArrayList();
        layerResult.forEach(layer -> {
            PlanLogDTO planLog = new PlanLogDTO();
            planLog.setLayer_code(layer.getLayerCode());
            if (Objects.equals(layer.isSuccess(), true)) {
                planLog.setIs_hit(1);
                planLog.setGroup_id(layer.getGroupId());
            } else {
                planLog.setIs_hit(0);
            }
            list.add(planLog);
        });
        json.put("plan", (Object)JSON.toJSONString(list));
        this.queue.add(json);
    }

    private List<TestSlotPlanDTO> filter(String extra, String layerCode, TestSlotDTO dto) {
        List<TestSlotPlanDTO> slotPlans = dto.getTestPlans();
        ArrayList<TestSlotPlanDTO> plans = new ArrayList<TestSlotPlanDTO>();
        Date now = new Date();
        for (TestSlotPlanDTO slotPlan : slotPlans) {
            TestPlanDTO planDTO = slotPlan.getTestPlan();
            if (Objects.isNull(planDTO)) {
                this.logger.warn("\u5b9e\u9a8c\u8ba1\u5212\u4e3a\u7a7a!,layerCode:[{}],extra:[{}]", (Object)layerCode, (Object)extra);
            }
            if (now.before(planDTO.getStartTime()) || now.after(planDTO.getEndTime()) || planDTO.getTestPlanGroups().get(layerCode) == null) continue;
            List<TestConditionDTO> conditionValues = planDTO.getConditionValues();
            if (CollectionUtils.isEmpty(conditionValues)) {
                plans.add(slotPlan);
                continue;
            }
            if (StringUtils.isBlank((CharSequence)extra)) continue;
            Map<String, String> conditionValueMap = JSONObject.parseObject((String)extra).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> entry.getValue().toString()));
            boolean flag = false;
            for (TestConditionDTO conditionValue : conditionValues) {
                String s = conditionValueMap.get(conditionValue.getConditionField());
                if (StringUtils.isBlank((CharSequence)s)) {
                    flag = false;
                    break;
                }
                if (!StringUtils.isNotBlank((CharSequence)s)) continue;
                List<String> conditionValueList = conditionValue.getConditionValueList();
                if (conditionValueList.contains(s)) {
                    flag = true;
                    continue;
                }
                flag = false;
                break;
            }
            if (!flag) continue;
            plans.add(slotPlan);
        }
        return plans;
    }

    private Integer getDomainPercent(List<TestSlotPlanDTO> testPlans) {
        if (CollectionUtils.isEmpty(testPlans)) {
            return 0;
        }
        Integer domainPercent = 0;
        for (TestSlotPlanDTO testPlan : testPlans) {
            if (testPlan.getTestPlan().getDomainType() != 1) continue;
            domainPercent = domainPercent + testPlan.getPercent();
        }
        return domainPercent;
    }

    private List<TestSlotPlanDTO> filterNotDomainPlans(List<TestSlotPlanDTO> testPlans) {
        testPlans = testPlans.stream().filter(o -> o.getTestPlan().getDomainType() == 0).collect(Collectors.toList());
        return testPlans;
    }

    private Boolean isDomainHash(List<TestSlotPlanDTO> testPlans, ABRequestDto request) {
        int domainHash = 0;
        domainHash = this.hash(request.getDeviceId()) % 100;
        TestSlotPlanDTO current = null;
        for (TestSlotPlanDTO slotPlan : testPlans) {
            if (!slotPlan.getPercentDistrictSet().contains(domainHash) || slotPlan.getTestPlan().getDomainType() != 1) continue;
            current = slotPlan;
            break;
        }
        if (current == null) {
            return false;
        }
        return true;
    }

    private TestSlotDTO NullObject(Long slotId) {
        TestSlotDTO dto = new TestSlotDTO();
        dto.setSlotId(slotId);
        dto.setId(-1L);
        dto.setTestPlans(new ArrayList<TestSlotPlanDTO>());
        return dto;
    }

    private TestSlotDTO NullObject(String layerCode) {
        TestSlotDTO dto = new TestSlotDTO();
        dto.setSlotId(-1L);
        dto.setTestLayerCode(layerCode);
        dto.setId(-1L);
        dto.setTestPlans(new ArrayList<TestSlotPlanDTO>());
        return dto;
    }
}

