package com.duiba.tuia.abtest.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.alibaba.fastjson.JSONObject;
import com.duiba.tuia.abtest.api.ABTestException;
import com.duiba.tuia.abtest.api.dto.*;

import java.util.List;

/**
 * ABTest 实验相关接口
 */
@AdvancedFeignClient
public interface RemoteABTestService {

    /**
     * 执行ABTest
     *
     * @param request 输入参数
     * @return 实验结果
     */
    ABResponseDto run(ABRequestDto request);


    /**
     * @Description  广告定制run接口(支持批量传层编号)
     * @Param [request]
     * @return com.duiba.tuia.abtest.api.dto.ABAdvertResponseDto
     **/
    ABAdvertResponseDto advertRun(ABRequestDto request);

    /**
     * @Description  广告实验分流对接接口,批量广告计划
     * @Param [request]
     * @return com.duiba.tuia.abtest.api.dto.ABAdvertResponseDto
     **/
    ABAdvertResponseBatchDto advertRunBatch(List<ABRequestDto> request);


    /**
     * 添加广告位黑名单
     * */
    void addBlackListSlot(Long slotId, Long appId);

    /**
     * @Description 获取广告位维度缓存
     * @Date 2:53 下午 2021/4/20
     * @Param [slotId]
     * @return com.duiba.tuia.abtest.api.dto.TestSlotDTO
     **/
    TestSlotDTO getSlotCache(Long slotId);

    /**
     * @Description 获取广告算法缓存(全局流量维度)
     * @Date 2:53 下午 2021/4/20
     * @Param [slotId]
     * @return com.duiba.tuia.abtest.api.dto.TestSlotDTO
     **/
    TestSlotDTO getAdvertAlgoCache(String layerCode);

    /**
     * @Description 获取广告计划维度缓存
     * @Date 2:53 下午 2021/4/20
     * @Param [slotId]
     * @return com.duiba.tuia.abtest.api.dto.TestSlotDTO
     **/
    TestSlotDTO getAdvertCache(ABCacheRequestDto cacheRequestDto);

    /**
     * @Description 批量打日志接口
     * @Date 7:33 下午 2021/4/21
     * @Param [requestTests]
     * @return void
     **/
    void batchLog(List<JSONObject> requestTests);

    /**
     * 根据广告位id列表查询广告位黑名单
     */
    TestSlotBlackListResp getSlotBlackIdsById(TestSlotBlackListReq testSlotBlackListReq);
}
