package com.duiba.tuia.abtest.api.dto;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * ABTest 输出结果
 */
public class ABResponseDto implements Serializable {

    /**
     * 是否走实验
     */
    private boolean success;

    /**
     * 实验异常信息
     */
    private String msg;

    /**
     * 实验ID
     */
    private Long planId;

    /**
     * 层对应的实验结果
     */
    private List<ABResultDto> result;

    public ABResponseDto() {

    }

    private static final ABResponseDto failDto = new ABResponseDto(false, "参数错误，没有slotId");

    public static ABResponseDto getFailDto() {
        return failDto;
    }

    public ABResponseDto(boolean success) {
        this.success = success;
    }

    public ABResponseDto(boolean success, String msg) {
        this.success = success;
        this.msg = msg;
    }

    public ABResponseDto(boolean success, long planId, List<ABResultDto> list) {
        this.success = success;
        this.planId = planId;
        this.result = list;
    }

    public boolean isSuccess() {
        return success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public Long getPlanId() {
        return planId;
    }

    public void setPlanId(Long planId) {
        this.planId = planId;
    }

    public List<ABResultDto> getResult() {
        return result;
    }

    public void setResult(List<ABResultDto> result) {
        this.result = result;
    }
}
