package com.duiba.tuia.abtest.api.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Set;

@Data
public class TestPlanGroupDTO implements Serializable {
    private static final long serialVersionUID = -1367782267912923580L;
    /**
     * 测试层编号
     */
    private String testLayerCode;
    /**
     * 实验组ID
     */
    private String groupId;
    /**
     * 实验组名称
     */
    private String groupName;
    /**
     * 测试类型 @See ABType
     */
    private String testType;
    /**
     * 实验结果
     */
    private String testValue;
    /**
     * 流量比例百分比%
     */
    private Integer percent;

    /**
     * 流量比例的区间 0～99:  1,2,5,6
     */
    private String percentDistrict;
    /**
     * 流量比例的区间Set用于快速匹配
     */
    private Set<Integer> percentDistrictSet;


    @ApiModelProperty("算法版本ID")
    private Long algoVersionId;


    //------入参使用-------//
    private Integer testRatio;

    private Integer advertRatio = 0;

}
