/*
 * Decompiled with CFR 0.152.
 */
package com.ebscn.activity.sdk.common.dto;

import com.ebscn.activity.sdk.common.exception.SdkRuntimeException;
import com.ebscn.activity.sdk.common.utils.DateUtils;

public class LimitDTO {
    private Long limit;
    private String type;
    private String fieldId;

    public String getLimitText() {
        if (this.limit != null) {
            return this.limit + "/" + LimitDTO.getTypeText(this.type);
        }
        return null;
    }

    public static String getTypeText(String type) {
        if (Type.Day.name().equalsIgnoreCase(type)) {
            return "\u6bcf\u65e5";
        }
        if (Type.Week.name().equalsIgnoreCase(type)) {
            return "\u6bcf\u5468";
        }
        if (Type.Month.name().equalsIgnoreCase(type)) {
            return "\u6bcf\u6708";
        }
        if (Type.Forever.name().equalsIgnoreCase(type) || Type.Everyday.name().equalsIgnoreCase(type)) {
            return "\u6c38\u4e45";
        }
        throw new SdkRuntimeException("limit type is null");
    }

    public String getTypeKey() {
        if (Type.Day.name().equalsIgnoreCase(this.type)) {
            return this.type + "_" + DateUtils.getDayOfYear();
        }
        if (Type.Week.name().equalsIgnoreCase(this.type)) {
            return this.type + "_" + DateUtils.getWeekOfYear();
        }
        if (Type.Month.name().equalsIgnoreCase(this.type)) {
            return this.type + "_" + DateUtils.getMonthOfYear();
        }
        if (Type.Forever.name().equalsIgnoreCase(this.type) || Type.Everyday.name().equalsIgnoreCase(this.type)) {
            return this.type;
        }
        throw new SdkRuntimeException("limit type is null");
    }

    public Long getLimit() {
        return this.limit;
    }

    public String getType() {
        return this.type;
    }

    public String getFieldId() {
        return this.fieldId;
    }

    public void setLimit(Long limit) {
        this.limit = limit;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setFieldId(String fieldId) {
        this.fieldId = fieldId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LimitDTO)) {
            return false;
        }
        LimitDTO other = (LimitDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$limit = this.getLimit();
        Long other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$fieldId = this.getFieldId();
        String other$fieldId = other.getFieldId();
        return !(this$fieldId == null ? other$fieldId != null : !this$fieldId.equals(other$fieldId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LimitDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $fieldId = this.getFieldId();
        result = result * 59 + ($fieldId == null ? 43 : $fieldId.hashCode());
        return result;
    }

    public String toString() {
        return "LimitDTO(limit=" + this.getLimit() + ", type=" + this.getType() + ", fieldId=" + this.getFieldId() + ")";
    }

    public static enum Type {
        Day,
        Week,
        Month,
        Forever,
        Everyday;

    }
}

