/*
 * Decompiled with CFR 0.152.
 */
package com.ebscn.activity.sdk.common.utils;

import com.ebscn.activity.sdk.common.utils.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NumberUtils {
    private static final BigDecimal ONE_HUNDRED = new BigDecimal(100).setScale(2, RoundingMode.FLOOR);
    private static final Pattern NUMBER_PATTERN = Pattern.compile("[0-9]*");

    public static boolean isNumeric(String str) {
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        Matcher matcher = NUMBER_PATTERN.matcher(str);
        return matcher.matches();
    }

    public static String toPlainString(String price) {
        if (price == null) {
            return null;
        }
        BigDecimal a = new BigDecimal(price).setScale(2, RoundingMode.FLOOR);
        return a.stripTrailingZeros().toPlainString();
    }

    public static String toPlainString(Double price) {
        if (price == null) {
            return null;
        }
        BigDecimal a = new BigDecimal(price).setScale(2, RoundingMode.FLOOR);
        return a.stripTrailingZeros().toPlainString();
    }

    public static String toPlainString(Double price, int scale) {
        if (price == null) {
            return null;
        }
        BigDecimal a = new BigDecimal(price).setScale(scale, RoundingMode.FLOOR);
        return a.stripTrailingZeros().toPlainString();
    }

    public static Double scale(Double price, int scale) {
        if (price == null) {
            return null;
        }
        return new BigDecimal(price).setScale(scale, RoundingMode.FLOOR).doubleValue();
    }

    public static String scale(String price, int scale) {
        if (price == null) {
            return null;
        }
        return new BigDecimal(price).setScale(scale, RoundingMode.FLOOR).toString();
    }

    public static Double divide(Double x, Double y, int scale) {
        if (x == null || y == null || y == 0.0) {
            return 0.0;
        }
        BigDecimal a = new BigDecimal(x);
        BigDecimal b = new BigDecimal(y);
        return a.divide(b, scale, RoundingMode.FLOOR).doubleValue();
    }

    public static Double divide(Long x, Long y) {
        if (x == null || y == null || y == 0L) {
            return 0.0;
        }
        BigDecimal a = new BigDecimal(x);
        BigDecimal b = new BigDecimal(y);
        return a.divide(b, 2, RoundingMode.FLOOR).doubleValue();
    }

    public static Double multiply(Double x, Double y, int scale) {
        if (x == null || y == null || y == 0.0) {
            return 0.0;
        }
        BigDecimal a = new BigDecimal(x);
        BigDecimal b = new BigDecimal(y);
        return a.multiply(b).setScale(scale, RoundingMode.FLOOR).doubleValue();
    }

    public static Long multiply(Long x, Long y) {
        BigDecimal a = new BigDecimal(x);
        BigDecimal b = new BigDecimal(y);
        return a.multiply(b).longValue();
    }

    public static Double percent(Long x, Long y) {
        return NumberUtils.percent(new Double(x.longValue()), new Double(y.longValue()), 2);
    }

    public static Double percent(Double x, Double y) {
        return NumberUtils.percent(x, y, 2);
    }

    public static Double percent(Double x, Double y, int scale) {
        if (x == null || y == null || y == 0.0) {
            return 0.0;
        }
        Double ret = NumberUtils.divide(x, y, 6);
        return new BigDecimal(ret).multiply(ONE_HUNDRED).setScale(scale, RoundingMode.FLOOR).doubleValue();
    }

    public static Double percentCompare(Long x, Long y) {
        return NumberUtils.percentCompare(new Double(x.longValue()), new Double(y.longValue()), 2);
    }

    public static Double percentCompare(Double x, Double y) {
        return NumberUtils.percentCompare(x, y, 2);
    }

    public static Double percentCompare(Double x, Double y, int scale) {
        if (x == null || y == null || y == 0.0) {
            return 0.0;
        }
        Double var = x - y;
        Double ret = NumberUtils.divide(var, y, 6);
        return new BigDecimal(ret).multiply(ONE_HUNDRED).setScale(scale, RoundingMode.FLOOR).doubleValue();
    }

    public static String getPrice(Long price) {
        if (price == null) {
            return null;
        }
        return new BigDecimal(price).divide(ONE_HUNDRED, 2, RoundingMode.FLOOR).toString();
    }

    public static Long getPrice(String price) {
        if (price == null || price.isEmpty()) {
            return null;
        }
        return new BigDecimal(price).multiply(ONE_HUNDRED).longValue();
    }
}

