/*
 * Decompiled with CFR 0.152.
 */
package com.ebscn.activity.sdk.ctrl;

import com.ebscn.activity.sdk.SdkContext;
import com.ebscn.activity.sdk.common.annotation.log.LogBuried;
import com.ebscn.activity.sdk.common.annotation.log.LogEnum;
import com.ebscn.activity.sdk.common.prize.dto.PrizeResultDTO;
import com.ebscn.activity.sdk.common.utils.AssertUtils;
import com.ebscn.activity.sdk.component.checkin.CheckInApi;
import com.ebscn.activity.sdk.component.checkin.dto.CheckInForm;
import com.ebscn.activity.sdk.component.checkin.dto.CheckInRecordVO;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

public abstract class DefaultCheckInController {
    private static final Logger log = LoggerFactory.getLogger(DefaultCheckInController.class);
    @Autowired
    CheckInApi checkInApi;

    protected abstract CheckInForm getConfig();

    @GetMapping
    public CheckInRecordVO query(SdkContext ctx) {
        return this.checkInApi.query(ctx, this.getConfig());
    }

    @GetMapping
    public CheckInRecordVO queryByTime(SdkContext ctx, @RequestParam Date start, @RequestParam Date end) {
        AssertUtils.isNull(start, "start is null");
        AssertUtils.isNull(end, "end is null");
        return this.checkInApi.queryByTime(ctx, this.getConfig(), start, end);
    }

    @LogBuried(type={LogEnum.D403, LogEnum.D404})
    @PostMapping
    public List<PrizeResultDTO> checkin(SdkContext ctx, @RequestParam(required=false) Date time) {
        return this.checkInApi.doCheckIn(ctx, this.getConfig(), time);
    }
}

