/*
 * Decompiled with CFR 0.152.
 */
package com.ebscn.activity.sdk.ctrl;

import com.alibaba.fastjson.JSONObject;
import com.ebscn.activity.sdk.SdkContext;
import com.ebscn.activity.sdk.common.ConfineApi;
import com.ebscn.activity.sdk.common.ProjectApi;
import com.ebscn.activity.sdk.common.UserApi;
import com.ebscn.activity.sdk.common.annotation.log.LogBuried;
import com.ebscn.activity.sdk.common.annotation.log.LogEnum;
import com.ebscn.activity.sdk.common.dto.CreditsDTO;
import com.ebscn.activity.sdk.common.dto.ProjectDTO;
import com.ebscn.activity.sdk.common.dto.QueryVO;
import com.ebscn.activity.sdk.common.dto.UserDTO;
import com.ebscn.activity.sdk.common.prize.PrizeApi;
import com.ebscn.activity.sdk.common.prize.dto.PrizeDTO;
import com.ebscn.activity.sdk.common.prize.dto.PrizeRequestDTO;
import com.ebscn.activity.sdk.common.prize.dto.PrizeResultDTO;
import com.ebscn.activity.sdk.common.prize.dto.PrizeVO;
import com.ebscn.activity.sdk.common.utils.AssertUtils;
import com.ebscn.activity.sdk.component.game.GameRecordApi;
import com.ebscn.activity.sdk.component.game.dto.GameForm;
import com.ebscn.activity.sdk.component.game.dto.StartRequest;
import com.ebscn.activity.sdk.component.game.dto.StartVO;
import com.ebscn.activity.sdk.component.game.dto.SubmitParams;
import com.ebscn.activity.sdk.component.game.dto.SubmitRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

public abstract class DefaultGameController {
    private static final Logger log = LoggerFactory.getLogger(DefaultGameController.class);
    @Autowired
    private GameRecordApi gameRecordApi;
    @Autowired
    private UserApi userApi;
    @Autowired
    private ConfineApi confineApi;
    @Autowired
    private PrizeApi prizeStrategyApi;
    @Autowired
    private ProjectApi projectApi;

    protected abstract GameForm getConfig();

    @GetMapping
    public QueryVO query(SdkContext ctx) {
        QueryVO vo = new QueryVO();
        ProjectDTO project = this.projectApi.query();
        CreditsDTO credits = this.userApi.queryCredits(project.getCreditsType());
        vo.setUserCredits(credits.getCredits());
        vo.setCreditsUnit(credits.getCreditsTypeName());
        vo.setCredits(this.getConfig().getCredits());
        vo.setStartTime(project.getStart());
        vo.setEndTime(project.getEnd());
        vo.setDesc(this.getConfig().getDesc());
        vo.setLastFreeNumber(this.confineApi.getLimit(ctx, this.getConfig().getFreeLimit()));
        vo.setLastJoinNumber(this.confineApi.getLimit(ctx, this.getConfig().getJoinLimit()));
        vo.setPrizes(PrizeVO.convert(this.getConfig().getPries()));
        return vo;
    }

    @LogBuried(type={LogEnum.D403, LogEnum.D404})
    @PostMapping
    public StartVO start(SdkContext ctx) {
        StartRequest request = new StartRequest();
        request.setCredits(this.getConfig().getCredits());
        request.setFreeLimit(this.getConfig().getFreeLimit());
        request.setJoinLimit(this.getConfig().getJoinLimit());
        Long id = this.gameRecordApi.start(request);
        StartVO vo = new StartVO();
        vo.setId(id);
        vo.setLastJoinNumber(this.confineApi.getLimit(ctx, this.getConfig().getJoinLimit()));
        vo.setLastFreeNumber(this.confineApi.getLimit(ctx, this.getConfig().getFreeLimit()));
        UserDTO user = this.userApi.query();
        vo.setUserCredits(user.getCredits());
        return vo;
    }

    @PostMapping
    public PrizeResultDTO submit(SdkContext ctx, @RequestBody SubmitParams params) {
        SubmitRequest submitRequest = new SubmitRequest();
        submitRequest.setId(params.getId());
        submitRequest.setJson((JSONObject)JSONObject.toJSON((Object)params));
        boolean submit = this.gameRecordApi.submit(submitRequest);
        AssertUtils.isFalse(submit, "\u5df2\u7ecf\u63d0\u4ea4\u8fc7\u4e86\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4");
        if (params.getScore() == 0L || this.getConfig().getMinScore() != null && params.getScore() < (long)this.getConfig().getMinScore().intValue()) {
            PrizeResultDTO result = new PrizeResultDTO();
            result.setOrderNo(PrizeDTO.Type.None.name());
            result.setStatus(PrizeResultDTO.Success_Thanks);
            result.setPrize(PrizeVO.convert(PrizeDTO.getNonePrize()));
            return result;
        }
        PrizeRequestDTO prizeRequest = new PrizeRequestDTO();
        prizeRequest.setPrizes(this.getConfig().getPries());
        prizeRequest.setSourceId(submitRequest.getId());
        return this.prizeStrategyApi.randomPrizeSync(prizeRequest);
    }
}

