package com.atlassian.instrumentation.instruments;

import java.util.Optional;

import com.atlassian.instrumentation.driver.Instrumentation;

/**
 * This class times an operation
 *
 * @since v6.3
 */
public class Timer implements Context {

    private final Class<?> clazz;
    private final String databaseName;
    private final Optional<String> sql;
    private final Optional<String> sqlId;
    private final Optional<EventType> eventType;
    private Instrumentation.Split split;

    public Timer(Class<?> clazz, String databaseName, Optional<String> sql, Optional<String> sqlId,
            Optional<EventType> eventType) {
        this.clazz = clazz;
        this.databaseName = databaseName;
        this.sql = sql;
        this.sqlId = sqlId;
        this.eventType = eventType;
    }

    public void start() {
        if (split != null)
            throw new IllegalStateException("timer already started");
        split = Instrumentation.startSplit(this);
    }

    public void stop() {
        split.stop();
    }

    public Class<?> getClazz()
    {
        return clazz;
    }

    public String getDatabaseName()
    {
        return databaseName;
    }

    public Optional<String> getSql()
    {
        return sql;
    }

    public Optional<String> getSqlId()
    {
        return sqlId;
    }

    public Optional<EventType> getEventType()
    {
        return eventType;
    }
}
