/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricio.async.db.postgresql.encoders;

import com.github.mauricio.async.db.column.ColumnEncoderRegistry;
import com.github.mauricio.async.db.postgresql.encoders.Encoder;
import com.github.mauricio.async.db.postgresql.encoders.PreparedStatementEncoderHelper;
import com.github.mauricio.async.db.postgresql.encoders.PreparedStatementOpeningEncoder$;
import com.github.mauricio.async.db.postgresql.messages.frontend.ClientMessage;
import com.github.mauricio.async.db.postgresql.messages.frontend.PreparedStatementOpeningMessage;
import com.github.mauricio.async.db.util.ByteBufferUtils$;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r<Q!\u0001\u0002\t\u0002E\tq\u0004\u0015:fa\u0006\u0014X\rZ*uCR,W.\u001a8u\u001fB,g.\u001b8h\u000b:\u001cw\u000eZ3s\u0015\t\u0019A!\u0001\u0005f]\u000e|G-\u001a:t\u0015\t)a!\u0001\u0006q_N$xM]3tc2T!a\u0002\u0005\u0002\u0005\u0011\u0014'BA\u0005\u000b\u0003\u0015\t7/\u001f8d\u0015\tYA\"\u0001\u0005nCV\u0014\u0018nY5p\u0015\tia\"\u0001\u0004hSRDWO\u0019\u0006\u0002\u001f\u0005\u00191m\\7\u0004\u0001A\u0011!cE\u0007\u0002\u0005\u0019)AC\u0001E\u0001+\ty\u0002K]3qCJ,Gm\u0015;bi\u0016lWM\u001c;Pa\u0016t\u0017N\\4F]\u000e|G-\u001a:\u0014\u0005M1\u0002CA\f\u001b\u001b\u0005A\"\"A\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005mA\"AB!osJ+g\rC\u0003\u001e'\u0011\u0005a$\u0001\u0004=S:LGO\u0010\u000b\u0002#!9\u0001e\u0005b\u0001\n\u0003\t\u0013a\u00017pOV\t!\u0005\u0005\u0002$Q5\tAE\u0003\u0002&M\u0005)1\u000f\u001c45U*\tq%A\u0002pe\u001eL!!\u000b\u0013\u0003\r1{wmZ3s\u0011\u0019Y3\u0003)A\u0005E\u0005!An\\4!\r\u0011!\"\u0001A\u0017\u0014\t12b&\r\t\u0003%=J!\u0001\r\u0002\u0003\u000f\u0015s7m\u001c3feB\u0011!CM\u0005\u0003g\t\u0011a\u0004\u0015:fa\u0006\u0014X\rZ*uCR,W.\u001a8u\u000b:\u001cw\u000eZ3s\u0011\u0016d\u0007/\u001a:\t\u0011Ub#\u0011!Q\u0001\nY\nqa\u00195beN,G\u000f\u0005\u00028{5\t\u0001H\u0003\u00026s)\u0011!hO\u0001\u0004]&|'\"\u0001\u001f\u0002\t)\fg/Y\u0005\u0003}a\u0012qa\u00115beN,G\u000f\u0003\u0005AY\t\u0005\t\u0015!\u0003B\u0003\u001d)gnY8eKJ\u0004\"AQ#\u000e\u0003\rS!\u0001\u0012\u0004\u0002\r\r|G.^7o\u0013\t15IA\u000bD_2,XN\\#oG>$WM\u001d*fO&\u001cHO]=\t\u000buaC\u0011\u0001%\u0015\u0007%S5\n\u0005\u0002\u0013Y!)Qg\u0012a\u0001m!)\u0001i\u0012a\u0001\u0003\")Q\n\fC!\u001d\u00061QM\\2pI\u0016$\"aT-\u0011\u0005A;V\"A)\u000b\u0005I\u001b\u0016A\u00022vM\u001a,'O\u0003\u0002U+\u0006)a.\u001a;us*\ta+\u0001\u0002j_&\u0011\u0001,\u0015\u0002\b\u0005f$XMQ;g\u0011\u0015QF\n1\u0001\\\u0003\u001diWm]:bO\u0016\u0004\"\u0001X1\u000e\u0003uS!AX0\u0002\u0011\u0019\u0014xN\u001c;f]\u0012T!\u0001\u0019\u0003\u0002\u00115,7o]1hKNL!AY/\u0003\u001b\rc\u0017.\u001a8u\u001b\u0016\u001c8/Y4f\u0001")
public class PreparedStatementOpeningEncoder
implements Encoder,
PreparedStatementEncoderHelper {
    private final Charset charset;
    private final ColumnEncoderRegistry encoder;

    public static Logger log() {
        return PreparedStatementOpeningEncoder$.MODULE$.log();
    }

    @Override
    public ByteBuf writeExecutePortal(byte[] statementIdBytes, String query, Seq<Object> values, ColumnEncoderRegistry encoder, Charset charset, boolean writeDescribe) {
        return PreparedStatementEncoderHelper.writeExecutePortal$(this, statementIdBytes, query, values, encoder, charset, writeDescribe);
    }

    @Override
    public boolean isNull(Object value) {
        return PreparedStatementEncoderHelper.isNull$(this, value);
    }

    @Override
    public boolean writeExecutePortal$default$6() {
        return PreparedStatementEncoderHelper.writeExecutePortal$default$6$(this);
    }

    @Override
    public ByteBuf encode(ClientMessage message) {
        PreparedStatementOpeningMessage m = (PreparedStatementOpeningMessage)message;
        byte[] statementIdBytes = ((Object)BoxesRunTime.boxToInteger((int)m.statementId())).toString().getBytes(this.charset);
        int columnCount = m.valueTypes().size();
        ByteBuf parseBuffer = Unpooled.buffer((int)1024);
        parseBuffer.writeByte(80);
        parseBuffer.writeInt(0);
        parseBuffer.writeBytes(statementIdBytes);
        parseBuffer.writeByte(0);
        parseBuffer.writeBytes(m.query().getBytes(this.charset));
        parseBuffer.writeByte(0);
        parseBuffer.writeShort(columnCount);
        if (PreparedStatementOpeningEncoder$.MODULE$.log().isDebugEnabled()) {
            PreparedStatementOpeningEncoder$.MODULE$.log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Opening query (", ") - statement id (", ") - selected types (", ") - values (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{m.query(), new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(statementIdBytes)).mkString("-"), m.valueTypes().mkString(", "), m.values().mkString(", ")})));
        }
        m.valueTypes().foreach((Function1 & java.io.Serializable & Serializable)kind -> parseBuffer.writeInt(BoxesRunTime.unboxToInt((Object)kind)));
        ByteBufferUtils$.MODULE$.writeLength(parseBuffer);
        ByteBuf executeBuffer = this.writeExecutePortal(statementIdBytes, m.query(), m.values(), this.encoder, this.charset, true);
        return Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{parseBuffer, executeBuffer});
    }

    public PreparedStatementOpeningEncoder(Charset charset, ColumnEncoderRegistry encoder) {
        this.charset = charset;
        this.encoder = encoder;
        PreparedStatementEncoderHelper.$init$(this);
    }
}

