/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.tomakehurst.wiremock.common.Exceptions;
import java.io.IOException;
import java.util.Map;

public final class Json {
    private static final ThreadLocal<ObjectMapper> objectMapperHolder = new ThreadLocal();

    private Json() {
    }

    public static <T> T read(String json, Class<T> clazz) {
        try {
            ObjectMapper mapper = Json.getObjectMapper();
            return (T)mapper.readValue(json, clazz);
        }
        catch (IOException ioe) {
            return Exceptions.throwUnchecked(ioe, clazz);
        }
    }

    public static <T> String write(T object) {
        try {
            ObjectMapper mapper = Json.getObjectMapper();
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(object);
        }
        catch (IOException ioe) {
            return Exceptions.throwUnchecked(ioe, String.class);
        }
    }

    private static ObjectMapper getObjectMapper() {
        if (objectMapperHolder.get() == null) {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            objectMapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
            objectMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            objectMapper.configure(JsonParser.Feature.IGNORE_UNDEFINED, true);
            objectMapperHolder.set(objectMapper);
        }
        return objectMapperHolder.get();
    }

    public static byte[] toByteArray(Object object) {
        try {
            ObjectMapper mapper = Json.getObjectMapper();
            return mapper.writeValueAsBytes(object);
        }
        catch (IOException ioe) {
            return Exceptions.throwUnchecked(ioe, byte[].class);
        }
    }

    public static JsonNode node(String json) {
        return Json.read(json, JsonNode.class);
    }

    public static int maxDeepSize(JsonNode one, JsonNode two) {
        return Math.max(Json.deepSize(one), Json.deepSize(two));
    }

    public static int deepSize(JsonNode node) {
        if (node == null) {
            return 0;
        }
        int acc = 0;
        if (node.isContainerNode()) {
            for (JsonNode child : node) {
                ++acc;
                if (!child.isContainerNode()) continue;
                acc += Json.deepSize(child);
            }
        } else {
            ++acc;
        }
        return acc;
    }

    public static String prettyPrint(String json) {
        ObjectMapper mapper = Json.getObjectMapper();
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(mapper.readValue(json, JsonNode.class));
        }
        catch (IOException e) {
            return Exceptions.throwUnchecked(e, String.class);
        }
    }

    public static <T> T mapToObject(Map<String, Object> map, Class<T> targetClass) {
        ObjectMapper mapper = Json.getObjectMapper();
        return (T)mapper.convertValue(map, targetClass);
    }

    public static <T> Map<String, Object> objectToMap(T theObject) {
        ObjectMapper mapper = Json.getObjectMapper();
        return (Map)mapper.convertValue(theObject, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }
}

