/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.bag.primitive.MutableCharBag;
import com.gs.collections.api.bag.primitive.MutableShortBag;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.function.primitive.CharToShortFunction;
import com.gs.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction0;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.block.function.primitive.ShortToShortFunction;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.block.predicate.primitive.CharShortPredicate;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.block.procedure.primitive.CharShortProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.block.procedure.primitive.ShortProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableShortCollection;
import com.gs.collections.api.collection.primitive.MutableShortCollection;
import com.gs.collections.api.iterator.CharIterator;
import com.gs.collections.api.iterator.ShortIterator;
import com.gs.collections.api.list.primitive.MutableCharList;
import com.gs.collections.api.list.primitive.MutableShortList;
import com.gs.collections.api.map.primitive.CharShortMap;
import com.gs.collections.api.map.primitive.ImmutableCharShortMap;
import com.gs.collections.api.map.primitive.MutableCharShortMap;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.CharSet;
import com.gs.collections.api.set.primitive.ImmutableCharSet;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.api.set.primitive.MutableShortSet;
import com.gs.collections.api.set.primitive.ShortSet;
import com.gs.collections.api.tuple.primitive.CharShortPair;
import com.gs.collections.impl.bag.mutable.primitive.CharHashBag;
import com.gs.collections.impl.bag.mutable.primitive.ShortHashBag;
import com.gs.collections.impl.collection.mutable.primitive.SynchronizedShortCollection;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableShortCollection;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.factory.primitive.CharSets;
import com.gs.collections.impl.factory.primitive.CharShortMaps;
import com.gs.collections.impl.factory.primitive.ShortLists;
import com.gs.collections.impl.lazy.AbstractLazyIterable;
import com.gs.collections.impl.lazy.primitive.AbstractLazyCharIterable;
import com.gs.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import com.gs.collections.impl.lazy.primitive.LazyShortIterableAdapter;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.list.mutable.primitive.CharArrayList;
import com.gs.collections.impl.list.mutable.primitive.ShortArrayList;
import com.gs.collections.impl.map.mutable.primitive.SynchronizedCharShortMap;
import com.gs.collections.impl.map.mutable.primitive.UnmodifiableCharShortMap;
import com.gs.collections.impl.set.mutable.primitive.CharHashSet;
import com.gs.collections.impl.set.mutable.primitive.ShortHashSet;
import com.gs.collections.impl.set.mutable.primitive.SynchronizedCharSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableCharSet;
import com.gs.collections.impl.tuple.primitive.PrimitiveTuples;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharShortHashMap
implements MutableCharShortMap,
Externalizable {
    static final short EMPTY_VALUE = 0;
    private static final long serialVersionUID = 1L;
    private static final char EMPTY_KEY = '\u0000';
    private static final char REMOVED_KEY = '\u0001';
    private static final int OCCUPIED_DATA_RATIO = 2;
    private static final int OCCUPIED_SENTINEL_RATIO = 4;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private char[] keys;
    private short[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private SentinelValues sentinelValues;

    public CharShortHashMap() {
        this.allocateTable(16);
    }

    public CharShortHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity * 2));
        this.allocateTable(capacity);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    public CharShortHashMap(CharShortMap map) {
        this(Math.max(map.size(), 8));
        this.putAll(map);
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    public static CharShortHashMap newWithKeysValues(char key1, short value1) {
        return new CharShortHashMap(1).withKeyValue(key1, value1);
    }

    public static CharShortHashMap newWithKeysValues(char key1, short value1, char key2, short value2) {
        return new CharShortHashMap(2).withKeysValues(key1, value1, key2, value2);
    }

    public static CharShortHashMap newWithKeysValues(char key1, short value1, char key2, short value2, char key3, short value3) {
        return new CharShortHashMap(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static CharShortHashMap newWithKeysValues(char key1, short value1, char key2, short value2, char key3, short value3, char key4, short value4) {
        return new CharShortHashMap(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CharShortMap)) {
            return false;
        }
        CharShortMap other = (CharShortMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey('\u0000') || other.containsKey('\u0001')) {
                return false;
            }
        } else {
            if (this.sentinelValues.containsZeroKey && (!other.containsKey('\u0000') || this.sentinelValues.zeroValue != other.getOrThrow('\u0000'))) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && (!other.containsKey('\u0001') || this.sentinelValues.oneValue != other.getOrThrow('\u0001'))) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            char key = this.keys[i];
            if (!CharShortHashMap.isNonSentinel(key) || other.containsKey(key) && this.values[i] == other.getOrThrow(key)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += 0 ^ this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey) {
                result += 1 ^ this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharShortHashMap.isNonSentinel(this.keys[i])) continue;
            result += this.keys[i] ^ this.values[i];
        }
        return result;
    }

    public String toString() {
        StringBuilder appendable = new StringBuilder();
        appendable.append("{");
        boolean first = true;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                appendable.append(String.valueOf('\u0000')).append("=").append(String.valueOf(this.sentinelValues.zeroValue));
                first = false;
            }
            if (this.sentinelValues.containsOneKey) {
                if (!first) {
                    appendable.append(", ");
                }
                appendable.append(String.valueOf('\u0001')).append("=").append(String.valueOf(this.sentinelValues.oneValue));
                first = false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            char key = this.keys[i];
            if (!CharShortHashMap.isNonSentinel(key)) continue;
            if (!first) {
                appendable.append(", ");
            }
            appendable.append(String.valueOf(key)).append("=").append(String.valueOf(this.values[i]));
            first = false;
        }
        appendable.append("}");
        return appendable.toString();
    }

    public int size() {
        return this.occupiedWithData + (this.sentinelValues == null ? 0 : this.sentinelValues.size());
    }

    public boolean isEmpty() {
        return this.occupiedWithData == 0 && (this.sentinelValues == null || this.sentinelValues.size() == 0);
    }

    public boolean notEmpty() {
        return this.occupiedWithData != 0 || this.sentinelValues != null && this.sentinelValues.size() != 0;
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            if (this.sentinelValues != null) {
                if (this.sentinelValues.containsZeroKey) {
                    appendable.append(String.valueOf(this.sentinelValues.zeroValue));
                    first = false;
                }
                if (this.sentinelValues.containsOneKey) {
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(this.sentinelValues.oneValue));
                    first = false;
                }
            }
            for (int i = 0; i < this.keys.length; ++i) {
                char key = this.keys[i];
                if (!CharShortHashMap.isNonSentinel(key)) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(this.values[i]));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ShortIterator shortIterator() {
        return new InternalShortIterator();
    }

    public short[] toArray() {
        short[] array = new short[this.size()];
        int index = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                array[index] = this.sentinelValues.zeroValue;
                ++index;
            }
            if (this.sentinelValues.containsOneKey) {
                array[index] = this.sentinelValues.oneValue;
                ++index;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharShortHashMap.isNonSentinel(this.keys[i])) continue;
            array[index] = this.values[i];
            ++index;
        }
        return array;
    }

    public boolean contains(short value) {
        return this.containsValue(value);
    }

    public boolean containsAll(short ... source) {
        for (short each : source) {
            if (this.contains(each)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(ShortIterable source) {
        return source.allSatisfy(new ShortPredicate(){

            public boolean accept(short value) {
                return CharShortHashMap.this.contains(value);
            }
        });
    }

    public void forEach(ShortProcedure procedure) {
        this.forEachValue(procedure);
    }

    public MutableShortCollection select(ShortPredicate predicate) {
        ShortArrayList result = new ShortArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharShortHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public MutableShortCollection reject(ShortPredicate predicate) {
        ShortArrayList result = new ShortArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharShortHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public <V> MutableCollection<V> collect(ShortToObjectFunction<? extends V> function) {
        FastList target = FastList.newList(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                target.add(function.valueOf(this.sentinelValues.zeroValue));
            }
            if (this.sentinelValues.containsOneKey) {
                target.add(function.valueOf(this.sentinelValues.oneValue));
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharShortHashMap.isNonSentinel(this.keys[i])) continue;
            target.add(function.valueOf(this.values[i]));
        }
        return target;
    }

    public short detectIfNone(ShortPredicate predicate, short value) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharShortHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return this.values[i];
        }
        return value;
    }

    public int count(ShortPredicate predicate) {
        int count = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                ++count;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                ++count;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharShortHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(ShortPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return true;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return true;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharShortHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(ShortPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharShortHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(ShortPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharShortHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public <V> V injectInto(V injectedValue, ObjectShortToObjectFunction<? super V, ? extends V> function) {
        Object result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.valueOf(result, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.valueOf(result, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharShortHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values[i]);
        }
        return result;
    }

    public MutableShortList toList() {
        return ShortArrayList.newList((ShortIterable)this);
    }

    public MutableShortSet toSet() {
        return ShortHashSet.newSet((ShortIterable)this);
    }

    public MutableShortBag toBag() {
        return ShortHashBag.newBag((ShortIterable)this);
    }

    public LazyShortIterable asLazy() {
        return new LazyShortIterableAdapter((ShortIterable)this);
    }

    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        Arrays.fill(this.keys, '\u0000');
        Arrays.fill(this.values, (short)0);
    }

    public void put(char key, short value) {
        if (CharShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.addEmptyKeyValue(value);
            return;
        }
        if (CharShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.addRemovedKeyValue(value);
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = value;
            return;
        }
        this.addKeyValueAtIndex(key, value, index);
    }

    public void putAll(CharShortMap map) {
        map.forEachKeyValue(new CharShortProcedure(){

            public void value(char key, short value) {
                CharShortHashMap.this.put(key, value);
            }
        });
    }

    public void removeKey(char key) {
        if (CharShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return;
            }
            this.removeEmptyKey();
            return;
        }
        if (CharShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return;
            }
            this.removeRemovedKey();
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.keys[index] = '\u0001';
            this.values[index] = 0;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
        }
    }

    public void remove(char key) {
        this.removeKey(key);
    }

    public short removeKeyIfAbsent(char key, short value) {
        if (CharShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return value;
            }
            short oldValue = this.sentinelValues.zeroValue;
            this.removeEmptyKey();
            return oldValue;
        }
        if (CharShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return value;
            }
            short oldValue = this.sentinelValues.oneValue;
            this.removeRemovedKey();
            return oldValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.keys[index] = '\u0001';
            short oldValue = this.values[index];
            this.values[index] = 0;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
            return oldValue;
        }
        return value;
    }

    public short getIfAbsentPut(char key, short value) {
        if (CharShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            this.addEmptyKeyValue(value);
            return value;
        }
        if (CharShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public short getIfAbsentPut(char key, ShortFunction0 function) {
        if (CharShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                short value = function.value();
                this.sentinelValues = new SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            short value = function.value();
            this.addEmptyKeyValue(value);
            return value;
        }
        if (CharShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                short value = function.value();
                this.sentinelValues = new SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            short value = function.value();
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        short value = function.value();
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public <P> short getIfAbsentPutWith(char key, ShortFunction<? super P> function, P parameter) {
        if (CharShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                short value = function.shortValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            short value = function.shortValueOf(parameter);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (CharShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                short value = function.shortValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            short value = function.shortValueOf(parameter);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        short value = function.shortValueOf(parameter);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public short getIfAbsentPutWithKey(char key, CharToShortFunction function) {
        if (CharShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                short value = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            short value = function.valueOf(key);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (CharShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                short value = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            short value = function.valueOf(key);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        short value = function.valueOf(key);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public short addToValue(char key, short toBeAdded) {
        if (CharShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.addEmptyKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = (short)(this.sentinelValues.zeroValue + toBeAdded);
            } else {
                this.addEmptyKeyValue(toBeAdded);
            }
            return this.sentinelValues.zeroValue;
        }
        if (CharShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.addRemovedKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = (short)(this.sentinelValues.oneValue + toBeAdded);
            } else {
                this.addRemovedKeyValue(toBeAdded);
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            int n = index;
            this.values[n] = (short)(this.values[n] + toBeAdded);
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, toBeAdded, index);
        return this.values[index];
    }

    private void addKeyValueAtIndex(char key, short value, int index) {
        if (this.keys[index] == '\u0001') {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    private void addEmptyKeyValue(short value) {
        this.sentinelValues.containsZeroKey = true;
        this.sentinelValues.zeroValue = value;
    }

    private void removeEmptyKey() {
        if (this.sentinelValues.containsOneKey) {
            this.sentinelValues.containsZeroKey = false;
            this.sentinelValues.zeroValue = (short)0;
        } else {
            this.sentinelValues = null;
        }
    }

    private void addRemovedKeyValue(short value) {
        this.sentinelValues.containsOneKey = true;
        this.sentinelValues.oneValue = value;
    }

    private void removeRemovedKey() {
        if (this.sentinelValues.containsZeroKey) {
            this.sentinelValues.containsOneKey = false;
            this.sentinelValues.oneValue = (short)0;
        } else {
            this.sentinelValues = null;
        }
    }

    public short updateValue(char key, short initialValueIfAbsent, ShortToShortFunction function) {
        if (CharShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(this.sentinelValues.zeroValue);
            } else {
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.zeroValue;
        }
        if (CharShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(this.sentinelValues.oneValue);
            } else {
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        short value = function.valueOf(initialValueIfAbsent);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public CharShortHashMap withKeyValue(char key1, short value1) {
        this.put(key1, value1);
        return this;
    }

    public CharShortHashMap withKeysValues(char key1, short value1, char key2, short value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public CharShortHashMap withKeysValues(char key1, short value1, char key2, short value2, char key3, short value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public CharShortHashMap withKeysValues(char key1, short value1, char key2, short value2, char key3, short value3, char key4, short value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public CharShortHashMap withoutKey(char key) {
        this.removeKey(key);
        return this;
    }

    public CharShortHashMap withoutAllKeys(CharIterable keys) {
        keys.forEach(new CharProcedure(){

            public void value(char key) {
                CharShortHashMap.this.removeKey(key);
            }
        });
        return this;
    }

    public MutableCharShortMap asUnmodifiable() {
        return new UnmodifiableCharShortMap(this);
    }

    public MutableCharShortMap asSynchronized() {
        return new SynchronizedCharShortMap(this);
    }

    public ImmutableCharShortMap toImmutable() {
        return CharShortMaps.immutable.ofAll((CharShortMap)this);
    }

    public short get(char key) {
        return this.getIfAbsent(key, (short)0);
    }

    public short getIfAbsent(char key, short ifAbsent) {
        if (CharShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return ifAbsent;
            }
            return this.sentinelValues.zeroValue;
        }
        if (CharShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return ifAbsent;
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        return ifAbsent;
    }

    public short getOrThrow(char key) {
        if (CharShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.zeroValue;
        }
        if (CharShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (CharShortHashMap.isNonSentinel(this.keys[index])) {
            return this.values[index];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(char key) {
        if (CharShortHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsZeroKey;
        }
        if (CharShortHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsOneKey;
        }
        return this.keys[this.probe(key)] == key;
    }

    public boolean containsValue(short value) {
        if (this.sentinelValues != null && this.sentinelValues.containsValue(value)) {
            return true;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (!CharShortHashMap.isNonSentinel(this.keys[i]) || this.values[i] != value) continue;
            return true;
        }
        return false;
    }

    public void forEachValue(ShortProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharShortHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.values[i]);
        }
    }

    public void forEachKey(CharProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value('\u0000');
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value('\u0001');
            }
        }
        for (char key : this.keys) {
            if (!CharShortHashMap.isNonSentinel(key)) continue;
            procedure.value(key);
        }
    }

    public void forEachKeyValue(CharShortProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value('\u0000', this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value('\u0001', this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharShortHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i], this.values[i]);
        }
    }

    public LazyCharIterable keysView() {
        return new KeysView();
    }

    public RichIterable<CharShortPair> keyValuesView() {
        return new KeyValuesView();
    }

    public CharShortHashMap select(CharShortPredicate predicate) {
        CharShortHashMap result = new CharShortHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept('\u0000', this.sentinelValues.zeroValue)) {
                result.put('\u0000', this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept('\u0001', this.sentinelValues.oneValue)) {
                result.put('\u0001', this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharShortHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public CharShortHashMap reject(CharShortPredicate predicate) {
        CharShortHashMap result = new CharShortHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept('\u0000', this.sentinelValues.zeroValue)) {
                result.put('\u0000', this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept('\u0001', this.sentinelValues.oneValue)) {
                result.put('\u0001', this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharShortHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public long sum() {
        long result = 0L;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += (long)this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey) {
                result += (long)this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharShortHashMap.isNonSentinel(this.keys[i])) continue;
            result += (long)this.values[i];
        }
        return result;
    }

    public short max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        ShortIterator iterator = this.shortIterator();
        short max = iterator.next();
        while (iterator.hasNext()) {
            short value = iterator.next();
            if (max >= value) continue;
            max = value;
        }
        return max;
    }

    public short maxIfEmpty(short defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    public short min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        ShortIterator iterator = this.shortIterator();
        short min = iterator.next();
        while (iterator.hasNext()) {
            short value = iterator.next();
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    public short minIfEmpty(short defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return (double)this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        short[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            short first = sortedArray[middleIndex];
            short second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public short[] toSortedArray() {
        short[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public MutableShortList toSortedList() {
        return ShortArrayList.newList((ShortIterable)this).sortThis();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                out.writeChar(0);
                out.writeShort(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                out.writeChar(1);
                out.writeShort(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!CharShortHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeChar(this.keys[i]);
            out.writeShort(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.put(in.readChar(), in.readShort());
        }
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehash() {
        this.rehash(this.keys.length);
    }

    private void rehashAndGrow() {
        this.rehash(this.keys.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        char[] old = this.keys;
        short[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!CharShortHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], oldValues[i]);
        }
    }

    int probe(char element) {
        int index = this.spread(element);
        char keyAtIndex = this.keys[index];
        if (keyAtIndex == element || keyAtIndex == '\u0000') {
            return index;
        }
        int removedIndex = keyAtIndex == '\u0001' ? index : -1;
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex += probe;
            probe += 17;
            if (this.keys[nextIndex &= this.keys.length - 1] == element) {
                return nextIndex;
            }
            if (this.keys[nextIndex] == '\u0001') {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (this.keys[nextIndex] == '\u0000') break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spread(char element) {
        int code = element;
        code ^= 0x3D ^ code >> 16;
        code += code << 3;
        code ^= code >> 4;
        code *= 668265261;
        code ^= code >> 15;
        return code & this.keys.length - 1;
    }

    private void allocateTable(int sizeToAllocate) {
        this.keys = new char[sizeToAllocate];
        this.values = new short[sizeToAllocate];
    }

    private static boolean isEmptyKey(char key) {
        return key == '\u0000';
    }

    private static boolean isRemovedKey(char key) {
        return key == '\u0001';
    }

    private static boolean isNonSentinel(char key) {
        return !CharShortHashMap.isEmptyKey(key) && !CharShortHashMap.isRemovedKey(key);
    }

    private int maxOccupiedWithData() {
        int capacity = this.keys.length;
        return Math.min(capacity - 1, capacity / 2);
    }

    private int maxOccupiedWithSentinels() {
        return this.keys.length / 4;
    }

    public MutableCharSet keySet() {
        return new KeySet();
    }

    public MutableShortCollection values() {
        return new ValuesCollection();
    }

    static /* synthetic */ char[] access$802(CharShortHashMap x0, char[] x1) {
        x0.keys = x1;
        return x1;
    }

    static /* synthetic */ short[] access$1002(CharShortHashMap x0, short[] x1) {
        x0.values = x1;
        return x1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyValuesView
    extends AbstractLazyIterable<CharShortPair> {
        private KeyValuesView() {
        }

        public void forEach(Procedure<? super CharShortPair> procedure) {
            if (CharShortHashMap.this.sentinelValues != null) {
                if (CharShortHashMap.this.sentinelValues.containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair('\u0000', CharShortHashMap.this.sentinelValues.zeroValue));
                }
                if (CharShortHashMap.this.sentinelValues.containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair('\u0001', CharShortHashMap.this.sentinelValues.oneValue));
                }
            }
            for (int i = 0; i < CharShortHashMap.this.keys.length; ++i) {
                if (!CharShortHashMap.isNonSentinel(CharShortHashMap.this.keys[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(CharShortHashMap.this.keys[i], CharShortHashMap.this.values[i]));
            }
        }

        public void forEachWithIndex(ObjectIntProcedure<? super CharShortPair> objectIntProcedure) {
            int index = 0;
            if (CharShortHashMap.this.sentinelValues != null) {
                if (CharShortHashMap.this.sentinelValues.containsZeroKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair('\u0000', CharShortHashMap.this.sentinelValues.zeroValue), index);
                    ++index;
                }
                if (CharShortHashMap.this.sentinelValues.containsOneKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair('\u0001', CharShortHashMap.this.sentinelValues.oneValue), index);
                    ++index;
                }
            }
            for (int i = 0; i < CharShortHashMap.this.keys.length; ++i) {
                if (!CharShortHashMap.isNonSentinel(CharShortHashMap.this.keys[i])) continue;
                objectIntProcedure.value((Object)PrimitiveTuples.pair(CharShortHashMap.this.keys[i], CharShortHashMap.this.values[i]), index);
                ++index;
            }
        }

        public <P> void forEachWith(Procedure2<? super CharShortPair, ? super P> procedure, P parameter) {
            if (CharShortHashMap.this.sentinelValues != null) {
                if (CharShortHashMap.this.sentinelValues.containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair('\u0000', CharShortHashMap.this.sentinelValues.zeroValue), parameter);
                }
                if (CharShortHashMap.this.sentinelValues.containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair('\u0001', CharShortHashMap.this.sentinelValues.oneValue), parameter);
                }
            }
            for (int i = 0; i < CharShortHashMap.this.keys.length; ++i) {
                if (!CharShortHashMap.isNonSentinel(CharShortHashMap.this.keys[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(CharShortHashMap.this.keys[i], CharShortHashMap.this.values[i]), parameter);
            }
        }

        public Iterator<CharShortPair> iterator() {
            return new InternalKeyValuesIterator();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class InternalKeyValuesIterator
        implements Iterator<CharShortPair> {
            private int count;
            private int position;
            private boolean handledZero;
            private boolean handledOne;

            @Override
            public CharShortPair next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called, but the iterator is exhausted");
                }
                ++this.count;
                if (!this.handledZero) {
                    this.handledZero = true;
                    if (CharShortHashMap.this.containsKey('\u0000')) {
                        return PrimitiveTuples.pair('\u0000', CharShortHashMap.this.sentinelValues.zeroValue);
                    }
                }
                if (!this.handledOne) {
                    this.handledOne = true;
                    if (CharShortHashMap.this.containsKey('\u0001')) {
                        return PrimitiveTuples.pair('\u0001', CharShortHashMap.this.sentinelValues.oneValue);
                    }
                }
                char[] keys = CharShortHashMap.this.keys;
                while (!CharShortHashMap.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                CharShortPair result = PrimitiveTuples.pair(keys[this.position], CharShortHashMap.this.values[this.position]);
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != CharShortHashMap.this.size();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValuesCollection
    implements MutableShortCollection {
        private ValuesCollection() {
        }

        public void clear() {
            CharShortHashMap.this.clear();
        }

        public MutableShortCollection select(ShortPredicate predicate) {
            return CharShortHashMap.this.select(predicate);
        }

        public MutableShortCollection reject(ShortPredicate predicate) {
            return CharShortHashMap.this.reject(predicate);
        }

        public short detectIfNone(ShortPredicate predicate, short ifNone) {
            return CharShortHashMap.this.detectIfNone(predicate, ifNone);
        }

        public <V> MutableCollection<V> collect(ShortToObjectFunction<? extends V> function) {
            return CharShortHashMap.this.collect(function);
        }

        public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function) {
            return CharShortHashMap.this.injectInto(injectedValue, function);
        }

        public long sum() {
            return CharShortHashMap.this.sum();
        }

        public short max() {
            return CharShortHashMap.this.max();
        }

        public short maxIfEmpty(short defaultValue) {
            return CharShortHashMap.this.maxIfEmpty(defaultValue);
        }

        public short min() {
            return CharShortHashMap.this.min();
        }

        public short minIfEmpty(short defaultValue) {
            return CharShortHashMap.this.minIfEmpty(defaultValue);
        }

        public double average() {
            return CharShortHashMap.this.average();
        }

        public double median() {
            return CharShortHashMap.this.median();
        }

        public short[] toSortedArray() {
            return CharShortHashMap.this.toSortedArray();
        }

        public MutableShortList toSortedList() {
            return CharShortHashMap.this.toSortedList();
        }

        public MutableShortCollection with(short element) {
            throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
        }

        public MutableShortCollection without(short element) {
            throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
        }

        public MutableShortCollection withAll(ShortIterable elements) {
            throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
        }

        public MutableShortCollection withoutAll(ShortIterable elements) {
            throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
        }

        public MutableShortCollection asUnmodifiable() {
            return UnmodifiableShortCollection.of(this);
        }

        public MutableShortCollection asSynchronized() {
            return SynchronizedShortCollection.of(this);
        }

        public ImmutableShortCollection toImmutable() {
            return ShortLists.immutable.withAll((ShortIterable)this);
        }

        public boolean contains(short value) {
            return CharShortHashMap.this.containsValue(value);
        }

        public boolean containsAll(short ... source) {
            return CharShortHashMap.this.containsAll(source);
        }

        public boolean containsAll(ShortIterable source) {
            return CharShortHashMap.this.containsAll(source);
        }

        public MutableShortList toList() {
            return CharShortHashMap.this.toList();
        }

        public MutableShortSet toSet() {
            return CharShortHashMap.this.toSet();
        }

        public MutableShortBag toBag() {
            return CharShortHashMap.this.toBag();
        }

        public LazyShortIterable asLazy() {
            return new LazyShortIterableAdapter((ShortIterable)this);
        }

        public boolean isEmpty() {
            return CharShortHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return CharShortHashMap.this.notEmpty();
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (CharShortHashMap.this.sentinelValues != null) {
                    if (CharShortHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(CharShortHashMap.this.sentinelValues.zeroValue));
                        first = false;
                    }
                    if (CharShortHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(CharShortHashMap.this.sentinelValues.oneValue));
                        first = false;
                    }
                }
                for (int i = 0; i < CharShortHashMap.this.keys.length; ++i) {
                    char key = CharShortHashMap.this.keys[i];
                    if (!CharShortHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(CharShortHashMap.this.values[i]));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public ShortIterator shortIterator() {
            return CharShortHashMap.this.shortIterator();
        }

        public void forEach(ShortProcedure procedure) {
            CharShortHashMap.this.forEach(procedure);
        }

        public int count(ShortPredicate predicate) {
            return CharShortHashMap.this.count(predicate);
        }

        public boolean anySatisfy(ShortPredicate predicate) {
            return CharShortHashMap.this.anySatisfy(predicate);
        }

        public boolean allSatisfy(ShortPredicate predicate) {
            return CharShortHashMap.this.allSatisfy(predicate);
        }

        public boolean noneSatisfy(ShortPredicate predicate) {
            return CharShortHashMap.this.noneSatisfy(predicate);
        }

        public boolean add(short element) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(short ... source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(ShortIterable source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean remove(short item) {
            int oldSize = CharShortHashMap.this.size();
            if (CharShortHashMap.this.sentinelValues != null) {
                if (CharShortHashMap.this.sentinelValues.containsZeroKey && item == CharShortHashMap.this.sentinelValues.zeroValue) {
                    CharShortHashMap.this.removeKey('\u0000');
                }
                if (CharShortHashMap.this.sentinelValues.containsOneKey && item == CharShortHashMap.this.sentinelValues.oneValue) {
                    CharShortHashMap.this.removeKey('\u0001');
                }
            }
            for (int i = 0; i < CharShortHashMap.this.keys.length; ++i) {
                if (!CharShortHashMap.isNonSentinel(CharShortHashMap.this.keys[i]) || item != CharShortHashMap.this.values[i]) continue;
                CharShortHashMap.this.removeKey(CharShortHashMap.this.keys[i]);
            }
            return oldSize != CharShortHashMap.this.size();
        }

        public boolean removeAll(ShortIterable source) {
            int oldSize = CharShortHashMap.this.size();
            ShortIterator iterator = source.shortIterator();
            while (iterator.hasNext()) {
                this.remove(iterator.next());
            }
            return oldSize != CharShortHashMap.this.size();
        }

        public boolean removeAll(short ... source) {
            int oldSize = CharShortHashMap.this.size();
            for (short item : source) {
                this.remove(item);
            }
            return oldSize != CharShortHashMap.this.size();
        }

        public boolean retainAll(ShortIterable source) {
            int oldSize = this.size();
            Object sourceSet = source instanceof ShortSet ? (ShortSet)source : source.toSet();
            CharShortHashMap retained = CharShortHashMap.this.select(new CharShortPredicate((ShortSet)sourceSet){
                final /* synthetic */ ShortSet val$sourceSet;
                {
                    this.val$sourceSet = shortSet;
                }

                public boolean accept(char key, short value) {
                    return this.val$sourceSet.contains(value);
                }
            });
            if (retained.size() != oldSize) {
                CharShortHashMap.access$802(CharShortHashMap.this, retained.keys);
                CharShortHashMap.access$1002(CharShortHashMap.this, retained.values);
                CharShortHashMap.this.sentinelValues = retained.sentinelValues;
                CharShortHashMap.this.occupiedWithData = retained.occupiedWithData;
                CharShortHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }

        public boolean retainAll(short ... source) {
            return this.retainAll((ShortIterable)ShortHashSet.newSetWith(source));
        }

        public int size() {
            return CharShortHashMap.this.size();
        }

        public short[] toArray() {
            return CharShortHashMap.this.toArray();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    implements MutableCharSet {
        private KeySet() {
        }

        public CharIterator charIterator() {
            return new KeySetIterator();
        }

        public void forEach(CharProcedure procedure) {
            CharShortHashMap.this.forEachKey(procedure);
        }

        public int count(CharPredicate predicate) {
            int count = 0;
            if (CharShortHashMap.this.sentinelValues != null) {
                if (CharShortHashMap.this.sentinelValues.containsZeroKey && predicate.accept('\u0000')) {
                    ++count;
                }
                if (CharShortHashMap.this.sentinelValues.containsOneKey && predicate.accept('\u0001')) {
                    ++count;
                }
            }
            for (char key : CharShortHashMap.this.keys) {
                if (!CharShortHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(CharPredicate predicate) {
            if (CharShortHashMap.this.sentinelValues != null) {
                if (CharShortHashMap.this.sentinelValues.containsZeroKey && predicate.accept('\u0000')) {
                    return true;
                }
                if (CharShortHashMap.this.sentinelValues.containsOneKey && predicate.accept('\u0001')) {
                    return true;
                }
            }
            for (char key : CharShortHashMap.this.keys) {
                if (!CharShortHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(CharPredicate predicate) {
            if (CharShortHashMap.this.sentinelValues != null) {
                if (CharShortHashMap.this.sentinelValues.containsZeroKey && !predicate.accept('\u0000')) {
                    return false;
                }
                if (CharShortHashMap.this.sentinelValues.containsOneKey && !predicate.accept('\u0001')) {
                    return false;
                }
            }
            for (char key : CharShortHashMap.this.keys) {
                if (!CharShortHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(CharPredicate predicate) {
            if (CharShortHashMap.this.sentinelValues != null) {
                if (CharShortHashMap.this.sentinelValues.containsZeroKey && predicate.accept('\u0000')) {
                    return false;
                }
                if (CharShortHashMap.this.sentinelValues.containsOneKey && predicate.accept('\u0001')) {
                    return false;
                }
            }
            for (char key : CharShortHashMap.this.keys) {
                if (!CharShortHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean add(char element) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(char ... source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(CharIterable source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean remove(char key) {
            int oldSize = CharShortHashMap.this.size();
            CharShortHashMap.this.removeKey(key);
            return oldSize != CharShortHashMap.this.size();
        }

        public boolean removeAll(CharIterable source) {
            int oldSize = CharShortHashMap.this.size();
            CharIterator iterator = source.charIterator();
            while (iterator.hasNext()) {
                CharShortHashMap.this.removeKey(iterator.next());
            }
            return oldSize != CharShortHashMap.this.size();
        }

        public boolean removeAll(char ... source) {
            int oldSize = CharShortHashMap.this.size();
            for (char item : source) {
                CharShortHashMap.this.removeKey(item);
            }
            return oldSize != CharShortHashMap.this.size();
        }

        public boolean retainAll(CharIterable source) {
            int oldSize = this.size();
            Object sourceSet = source instanceof CharSet ? (CharSet)source : source.toSet();
            CharShortHashMap retained = CharShortHashMap.this.select(new CharShortPredicate((CharSet)sourceSet){
                final /* synthetic */ CharSet val$sourceSet;
                {
                    this.val$sourceSet = charSet;
                }

                public boolean accept(char key, short value) {
                    return this.val$sourceSet.contains(key);
                }
            });
            if (retained.size() != oldSize) {
                CharShortHashMap.access$802(CharShortHashMap.this, retained.keys);
                CharShortHashMap.access$1002(CharShortHashMap.this, retained.values);
                CharShortHashMap.this.sentinelValues = retained.sentinelValues;
                CharShortHashMap.this.occupiedWithData = retained.occupiedWithData;
                CharShortHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }

        public boolean retainAll(char ... source) {
            return this.retainAll((CharIterable)CharHashSet.newSetWith(source));
        }

        public void clear() {
            CharShortHashMap.this.clear();
        }

        public MutableCharSet select(CharPredicate predicate) {
            CharHashSet result = new CharHashSet();
            if (CharShortHashMap.this.sentinelValues != null) {
                if (CharShortHashMap.this.sentinelValues.containsZeroKey && predicate.accept('\u0000')) {
                    result.add('\u0000');
                }
                if (CharShortHashMap.this.sentinelValues.containsOneKey && predicate.accept('\u0001')) {
                    result.add('\u0001');
                }
            }
            for (char key : CharShortHashMap.this.keys) {
                if (!CharShortHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableCharSet reject(CharPredicate predicate) {
            CharHashSet result = new CharHashSet();
            if (CharShortHashMap.this.sentinelValues != null) {
                if (CharShortHashMap.this.sentinelValues.containsZeroKey && !predicate.accept('\u0000')) {
                    result.add('\u0000');
                }
                if (CharShortHashMap.this.sentinelValues.containsOneKey && !predicate.accept('\u0001')) {
                    result.add('\u0001');
                }
            }
            for (char key : CharShortHashMap.this.keys) {
                if (!CharShortHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableCharSet with(char element) {
            throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
        }

        public MutableCharSet without(char element) {
            throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
        }

        public MutableCharSet withAll(CharIterable elements) {
            throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
        }

        public MutableCharSet withoutAll(CharIterable elements) {
            throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
        }

        public char detectIfNone(CharPredicate predicate, char ifNone) {
            if (CharShortHashMap.this.sentinelValues != null) {
                if (CharShortHashMap.this.sentinelValues.containsZeroKey && predicate.accept('\u0000')) {
                    return '\u0000';
                }
                if (CharShortHashMap.this.sentinelValues.containsOneKey && predicate.accept('\u0001')) {
                    return '\u0001';
                }
            }
            for (char key : CharShortHashMap.this.keys) {
                if (!CharShortHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return ifNone;
        }

        public <V> MutableSet<V> collect(CharToObjectFunction<? extends V> function) {
            MutableSet result = Sets.mutable.with();
            if (CharShortHashMap.this.sentinelValues != null) {
                if (CharShortHashMap.this.sentinelValues.containsZeroKey) {
                    result.add(function.valueOf('\u0000'));
                }
                if (CharShortHashMap.this.sentinelValues.containsOneKey) {
                    result.add(function.valueOf('\u0001'));
                }
            }
            for (char key : CharShortHashMap.this.keys) {
                if (!CharShortHashMap.isNonSentinel(key)) continue;
                result.add(function.valueOf(key));
            }
            return result;
        }

        public MutableCharSet asUnmodifiable() {
            return UnmodifiableCharSet.of(this);
        }

        public MutableCharSet asSynchronized() {
            return SynchronizedCharSet.of(this);
        }

        public long sum() {
            long sum = 0L;
            if (CharShortHashMap.this.sentinelValues != null) {
                if (CharShortHashMap.this.sentinelValues.containsZeroKey) {
                    sum += 0L;
                }
                if (CharShortHashMap.this.sentinelValues.containsOneKey) {
                    ++sum;
                }
            }
            for (char key : CharShortHashMap.this.keys) {
                if (!CharShortHashMap.isNonSentinel(key)) continue;
                sum += (long)key;
            }
            return sum;
        }

        public char max() {
            if (CharShortHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            char max = '\u0000';
            boolean isMaxSet = false;
            if (CharShortHashMap.this.sentinelValues != null) {
                if (CharShortHashMap.this.sentinelValues.containsZeroKey) {
                    max = '\u0000';
                    isMaxSet = true;
                }
                if (CharShortHashMap.this.sentinelValues.containsOneKey && (!isMaxSet || max < '\u0001')) {
                    max = '\u0001';
                    isMaxSet = true;
                }
            }
            for (int i = 0; i < CharShortHashMap.this.keys.length; ++i) {
                if (!CharShortHashMap.isNonSentinel(CharShortHashMap.this.keys[i]) || isMaxSet && max >= CharShortHashMap.this.keys[i]) continue;
                max = CharShortHashMap.this.keys[i];
                isMaxSet = true;
            }
            return max;
        }

        public char maxIfEmpty(char defaultValue) {
            if (CharShortHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public char min() {
            if (CharShortHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            char min = '\u0000';
            boolean isMinSet = false;
            if (CharShortHashMap.this.sentinelValues != null) {
                if (CharShortHashMap.this.sentinelValues.containsZeroKey) {
                    min = '\u0000';
                    isMinSet = true;
                }
                if (CharShortHashMap.this.sentinelValues.containsOneKey && (!isMinSet || '\u0001' < min)) {
                    min = '\u0001';
                    isMinSet = true;
                }
            }
            for (int i = 0; i < CharShortHashMap.this.keys.length; ++i) {
                if (!CharShortHashMap.isNonSentinel(CharShortHashMap.this.keys[i]) || isMinSet && CharShortHashMap.this.keys[i] >= min) continue;
                min = CharShortHashMap.this.keys[i];
                isMinSet = true;
            }
            return min;
        }

        public char minIfEmpty(char defaultValue) {
            if (CharShortHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public double average() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            return (double)this.sum() / (double)this.size();
        }

        public double median() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            char[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                char first = sortedArray[middleIndex];
                char second = sortedArray[middleIndex - 1];
                return ((double)first + (double)second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public char[] toSortedArray() {
            char[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public MutableCharList toSortedList() {
            return CharArrayList.newList((CharIterable)this).sortThis();
        }

        public char[] toArray() {
            int size = CharShortHashMap.this.size();
            final char[] result = new char[size];
            CharShortHashMap.this.forEachKey(new CharProcedure(){
                private int index;

                public void value(char each) {
                    result[this.index] = each;
                    ++this.index;
                }
            });
            return result;
        }

        public boolean contains(char value) {
            return CharShortHashMap.this.containsKey(value);
        }

        public boolean containsAll(char ... source) {
            for (char item : source) {
                if (CharShortHashMap.this.containsKey(item)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(CharIterable source) {
            CharIterator iterator = source.charIterator();
            while (iterator.hasNext()) {
                if (CharShortHashMap.this.containsKey(iterator.next())) continue;
                return false;
            }
            return true;
        }

        public MutableCharList toList() {
            return CharArrayList.newList((CharIterable)this);
        }

        public MutableCharSet toSet() {
            return CharHashSet.newSet((CharIterable)this);
        }

        public MutableCharBag toBag() {
            return CharHashBag.newBag((CharIterable)this);
        }

        public LazyCharIterable asLazy() {
            return new LazyCharIterableAdapter((CharIterable)this);
        }

        public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function) {
            Object result = injectedValue;
            if (CharShortHashMap.this.sentinelValues != null) {
                if (CharShortHashMap.this.sentinelValues.containsZeroKey) {
                    result = function.valueOf(result, '\u0000');
                }
                if (CharShortHashMap.this.sentinelValues.containsOneKey) {
                    result = function.valueOf(result, '\u0001');
                }
            }
            for (int i = 0; i < CharShortHashMap.this.keys.length; ++i) {
                if (!CharShortHashMap.isNonSentinel(CharShortHashMap.this.keys[i])) continue;
                result = function.valueOf(result, CharShortHashMap.this.keys[i]);
            }
            return result;
        }

        public CharSet freeze() {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".freeze() not implemented yet");
        }

        public ImmutableCharSet toImmutable() {
            return CharSets.immutable.withAll((CharIterable)this);
        }

        public int size() {
            return CharShortHashMap.this.size();
        }

        public boolean isEmpty() {
            return CharShortHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return CharShortHashMap.this.notEmpty();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CharSet)) {
                return false;
            }
            CharSet other = (CharSet)obj;
            return this.size() == other.size() && this.containsAll(other.toArray());
        }

        public int hashCode() {
            int result = 0;
            if (CharShortHashMap.this.sentinelValues != null) {
                if (CharShortHashMap.this.sentinelValues.containsZeroKey) {
                    result += 0;
                }
                if (CharShortHashMap.this.sentinelValues.containsOneKey) {
                    ++result;
                }
            }
            for (int i = 0; i < CharShortHashMap.this.keys.length; ++i) {
                if (!CharShortHashMap.isNonSentinel(CharShortHashMap.this.keys[i])) continue;
                result += CharShortHashMap.this.keys[i];
            }
            return result;
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (CharShortHashMap.this.sentinelValues != null) {
                    if (CharShortHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf('\u0000'));
                        first = false;
                    }
                    if (CharShortHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf('\u0001'));
                        first = false;
                    }
                }
                for (char key : CharShortHashMap.this.keys) {
                    if (!CharShortHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class KeySetIterator
    implements CharIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private KeySetIterator() {
        }

        public boolean hasNext() {
            return this.count < CharShortHashMap.this.size();
        }

        public char next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (CharShortHashMap.this.containsKey('\u0000')) {
                    return '\u0000';
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (CharShortHashMap.this.containsKey('\u0001')) {
                    return '\u0001';
                }
            }
            char[] keys = CharShortHashMap.this.keys;
            while (!CharShortHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            char result = keys[this.position];
            ++this.position;
            return result;
        }
    }

    private class KeysView
    extends AbstractLazyCharIterable {
        private KeysView() {
        }

        public CharIterator charIterator() {
            return new KeySetIterator();
        }

        public void forEach(CharProcedure procedure) {
            CharShortHashMap.this.forEachKey(procedure);
        }
    }

    private class InternalShortIterator
    implements ShortIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private InternalShortIterator() {
        }

        public boolean hasNext() {
            return this.count < CharShortHashMap.this.size();
        }

        public short next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (CharShortHashMap.this.containsKey('\u0000')) {
                    return CharShortHashMap.this.get('\u0000');
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (CharShortHashMap.this.containsKey('\u0001')) {
                    return CharShortHashMap.this.get('\u0001');
                }
            }
            char[] keys = CharShortHashMap.this.keys;
            while (!CharShortHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            short result = CharShortHashMap.this.values[this.position];
            ++this.position;
            return result;
        }
    }

    private static final class SentinelValues {
        private boolean containsZeroKey;
        private boolean containsOneKey;
        private short zeroValue;
        private short oneValue;

        private SentinelValues() {
        }

        public int size() {
            return (this.containsZeroKey ? 1 : 0) + (this.containsOneKey ? 1 : 0);
        }

        public boolean containsValue(short value) {
            boolean valueEqualsZeroValue = this.containsZeroKey && this.zeroValue == value;
            boolean valueEqualsOneValue = this.containsOneKey && this.oneValue == value;
            return valueEqualsZeroValue || valueEqualsOneValue;
        }
    }
}

