/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.SerializableString;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.JsonStringEncoder;
import java.io.Serializable;

public class SerializedString
implements SerializableString,
Serializable {
    private static final JsonStringEncoder JSON_ENCODER = JsonStringEncoder.getInstance();
    protected final String _value;
    protected byte[] _quotedUTF8Ref;
    protected byte[] _unquotedUTF8Ref;
    protected char[] _quotedChars;

    public SerializedString(String string) {
        if (string == null) {
            throw new IllegalStateException("Null String illegal for SerializedString");
        }
        this._value = string;
    }

    @Override
    public final String getValue() {
        return this._value;
    }

    @Override
    public final int charLength() {
        return this._value.length();
    }

    @Override
    public final char[] asQuotedChars() {
        char[] cArray = this._quotedChars;
        if (cArray == null) {
            this._quotedChars = cArray = JSON_ENCODER.quoteAsString(this._value);
        }
        return cArray;
    }

    @Override
    public final byte[] asQuotedUTF8() {
        byte[] byArray = this._quotedUTF8Ref;
        if (byArray == null) {
            this._quotedUTF8Ref = byArray = JSON_ENCODER.quoteAsUTF8(this._value);
        }
        return byArray;
    }

    @Override
    public final byte[] asUnquotedUTF8() {
        byte[] byArray = this._unquotedUTF8Ref;
        if (byArray == null) {
            this._unquotedUTF8Ref = byArray = JSON_ENCODER.encodeAsUTF8(this._value);
        }
        return byArray;
    }

    @Override
    public int appendQuoted(char[] cArray, int n2) {
        int n3;
        char[] cArray2 = this._quotedChars;
        if (cArray2 == null) {
            this._quotedChars = cArray2 = JSON_ENCODER.quoteAsString(this._value);
        }
        if (n2 + (n3 = cArray2.length) > cArray.length) {
            return -1;
        }
        System.arraycopy(cArray2, 0, cArray, n2, n3);
        return n3;
    }

    @Override
    public int appendQuotedUTF8(byte[] byArray, int n2) {
        int n3;
        byte[] byArray2 = this._quotedUTF8Ref;
        if (byArray2 == null) {
            this._quotedUTF8Ref = byArray2 = JSON_ENCODER.quoteAsUTF8(this._value);
        }
        if (n2 + (n3 = byArray2.length) > byArray.length) {
            return -1;
        }
        System.arraycopy(byArray2, 0, byArray, n2, n3);
        return n3;
    }

    @Override
    public int appendUnquoted(char[] cArray, int n2) {
        String string = this._value;
        int n3 = string.length();
        if (n2 + n3 > cArray.length) {
            return -1;
        }
        string.getChars(0, n3, cArray, n2);
        return n3;
    }

    @Override
    public int appendUnquotedUTF8(byte[] byArray, int n2) {
        int n3;
        byte[] byArray2 = this._unquotedUTF8Ref;
        if (byArray2 == null) {
            this._unquotedUTF8Ref = byArray2 = JSON_ENCODER.encodeAsUTF8(this._value);
        }
        if (n2 + (n3 = byArray2.length) > byArray.length) {
            return -1;
        }
        System.arraycopy(byArray2, 0, byArray, n2, n3);
        return n3;
    }

    public final String toString() {
        return this._value;
    }

    public final int hashCode() {
        return this._value.hashCode();
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        SerializedString serializedString = (SerializedString)object;
        return this._value.equals(serializedString._value);
    }
}

