/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.deser.std;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.annotation.JsonFormat;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.BeanProperty;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JsonDeserializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JsonMappingException;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.type.LogicalType;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.util.ClassUtil;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.util.StdDateFormat;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Locale;
import java.util.TimeZone;

public class DateDeserializers {
    private static final HashSet<String> _utilClasses = new HashSet();

    public static JsonDeserializer<?> find(Class<?> clazz, String string) {
        if (_utilClasses.contains(string)) {
            if (clazz == Calendar.class) {
                return new CalendarDeserializer();
            }
            if (clazz == Date.class) {
                return DateDeserializer.instance;
            }
            if (clazz == GregorianCalendar.class) {
                return new CalendarDeserializer((Class<? extends Calendar>)GregorianCalendar.class);
            }
        }
        return null;
    }

    static {
        _utilClasses.add("java.util.Calendar");
        _utilClasses.add("java.util.GregorianCalendar");
        _utilClasses.add("java.util.Date");
    }

    @JacksonStdImpl
    public static class DateDeserializer
    extends DateBasedDeserializer<Date> {
        public static final DateDeserializer instance = new DateDeserializer();

        public DateDeserializer() {
            super(Date.class);
        }

        public DateDeserializer(DateDeserializer dateDeserializer, DateFormat dateFormat, String string) {
            super(dateDeserializer, dateFormat, string);
        }

        protected DateDeserializer withDateFormat(DateFormat dateFormat, String string) {
            return new DateDeserializer(this, dateFormat, string);
        }

        @Override
        public Object getEmptyValue(DeserializationContext deserializationContext) {
            return new Date(0L);
        }

        @Override
        public Date deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return this._parseDate(jsonParser, deserializationContext);
        }
    }

    @JacksonStdImpl
    public static class CalendarDeserializer
    extends DateBasedDeserializer<Calendar> {
        protected final Constructor<Calendar> _defaultCtor;

        public CalendarDeserializer() {
            super(Calendar.class);
            this._defaultCtor = null;
        }

        public CalendarDeserializer(Class<? extends Calendar> clazz) {
            super(clazz);
            this._defaultCtor = ClassUtil.findConstructor(clazz, false);
        }

        public CalendarDeserializer(CalendarDeserializer calendarDeserializer, DateFormat dateFormat, String string) {
            super(calendarDeserializer, dateFormat, string);
            this._defaultCtor = calendarDeserializer._defaultCtor;
        }

        protected CalendarDeserializer withDateFormat(DateFormat dateFormat, String string) {
            return new CalendarDeserializer(this, dateFormat, string);
        }

        @Override
        public Object getEmptyValue(DeserializationContext deserializationContext) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTimeInMillis(0L);
            return gregorianCalendar;
        }

        @Override
        public Calendar deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            Date date = this._parseDate(jsonParser, deserializationContext);
            if (date == null) {
                return null;
            }
            if (this._defaultCtor == null) {
                return deserializationContext.constructCalendar(date);
            }
            try {
                Calendar calendar = this._defaultCtor.newInstance(new Object[0]);
                calendar.setTimeInMillis(date.getTime());
                TimeZone timeZone = deserializationContext.getTimeZone();
                if (timeZone != null) {
                    calendar.setTimeZone(timeZone);
                }
                return calendar;
            }
            catch (Exception exception) {
                return (Calendar)deserializationContext.handleInstantiationProblem(this.handledType(), date, exception);
            }
        }
    }

    protected static abstract class DateBasedDeserializer<T>
    extends StdScalarDeserializer<T>
    implements ContextualDeserializer {
        protected final DateFormat _customFormat;
        protected final String _formatString;

        protected DateBasedDeserializer(Class<?> clazz) {
            super(clazz);
            this._customFormat = null;
            this._formatString = null;
        }

        protected DateBasedDeserializer(DateBasedDeserializer<T> dateBasedDeserializer, DateFormat dateFormat, String string) {
            super(dateBasedDeserializer._valueClass);
            this._customFormat = dateFormat;
            this._formatString = string;
        }

        protected abstract DateBasedDeserializer<T> withDateFormat(DateFormat var1, String var2);

        @Override
        public LogicalType logicalType() {
            return LogicalType.DateTime;
        }

        @Override
        public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) throws JsonMappingException {
            JsonFormat.Value value = this.findFormatOverrides(deserializationContext, beanProperty, this.handledType());
            if (value != null) {
                TimeZone timeZone = value.getTimeZone();
                Boolean bl2 = value.getLenient();
                if (value.hasPattern()) {
                    String string = value.getPattern();
                    Locale locale = value.hasLocale() ? value.getLocale() : deserializationContext.getLocale();
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, locale);
                    if (timeZone == null) {
                        timeZone = deserializationContext.getTimeZone();
                    }
                    simpleDateFormat.setTimeZone(timeZone);
                    if (bl2 != null) {
                        simpleDateFormat.setLenient(bl2);
                    }
                    return this.withDateFormat(simpleDateFormat, string);
                }
                if (timeZone != null) {
                    DateFormat dateFormat = deserializationContext.getConfig().getDateFormat();
                    if (dateFormat.getClass() == StdDateFormat.class) {
                        Locale locale = value.hasLocale() ? value.getLocale() : deserializationContext.getLocale();
                        StdDateFormat stdDateFormat = (StdDateFormat)dateFormat;
                        stdDateFormat = stdDateFormat.withTimeZone(timeZone);
                        stdDateFormat = stdDateFormat.withLocale(locale);
                        if (bl2 != null) {
                            stdDateFormat = stdDateFormat.withLenient(bl2);
                        }
                        dateFormat = stdDateFormat;
                    } else {
                        dateFormat = (DateFormat)dateFormat.clone();
                        dateFormat.setTimeZone(timeZone);
                        if (bl2 != null) {
                            dateFormat.setLenient(bl2);
                        }
                    }
                    return this.withDateFormat(dateFormat, this._formatString);
                }
                if (bl2 != null) {
                    DateFormat dateFormat = deserializationContext.getConfig().getDateFormat();
                    String string = this._formatString;
                    if (dateFormat.getClass() == StdDateFormat.class) {
                        StdDateFormat stdDateFormat = (StdDateFormat)dateFormat;
                        stdDateFormat = stdDateFormat.withLenient(bl2);
                        dateFormat = stdDateFormat;
                        string = stdDateFormat.toPattern();
                    } else {
                        dateFormat = (DateFormat)dateFormat.clone();
                        dateFormat.setLenient(bl2);
                        if (dateFormat instanceof SimpleDateFormat) {
                            ((SimpleDateFormat)dateFormat).toPattern();
                        }
                    }
                    if (string == null) {
                        string = "[unknown]";
                    }
                    return this.withDateFormat(dateFormat, string);
                }
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Date _parseDate(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            if (this._customFormat != null && jsonParser.hasToken(JsonToken.VALUE_STRING)) {
                String string = jsonParser.getText().trim();
                if (string.isEmpty()) {
                    CoercionAction coercionAction = this._checkFromStringCoercion(deserializationContext, string);
                    switch (coercionAction) {
                        case AsEmpty: {
                            return new Date(0L);
                        }
                    }
                    return null;
                }
                DateFormat dateFormat = this._customFormat;
                synchronized (dateFormat) {
                    try {
                        return this._customFormat.parse(string);
                    }
                    catch (ParseException parseException) {
                        return (Date)deserializationContext.handleWeirdStringValue(this.handledType(), string, "expected format \"%s\"", this._formatString);
                    }
                }
            }
            return super._parseDate(jsonParser, deserializationContext);
        }
    }
}

