/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.google.common.hash;

import com.gradle.scan.plugin.internal.dep.com.google.common.base.Preconditions;
import com.gradle.scan.plugin.internal.dep.com.google.common.hash.AbstractHashFunction;
import com.gradle.scan.plugin.internal.dep.com.google.common.hash.AbstractHasher;
import com.gradle.scan.plugin.internal.dep.com.google.common.hash.HashCode;
import com.gradle.scan.plugin.internal.dep.com.google.common.hash.Hasher;
import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;

abstract class AbstractNonStreamingHashFunction
extends AbstractHashFunction {
    AbstractNonStreamingHashFunction() {
    }

    @Override
    public Hasher newHasher() {
        return this.newHasher(32);
    }

    @Override
    public Hasher newHasher(int n2) {
        Preconditions.checkArgument(n2 >= 0);
        return new BufferingHasher(n2);
    }

    @Override
    public HashCode hashString(CharSequence charSequence, Charset charset) {
        return this.hashBytes(charSequence.toString().getBytes(charset));
    }

    @Override
    public abstract HashCode hashBytes(byte[] var1, int var2, int var3);

    private static final class ExposedByteArrayOutputStream
    extends ByteArrayOutputStream {
        ExposedByteArrayOutputStream(int n2) {
            super(n2);
        }

        byte[] byteArray() {
            return this.buf;
        }

        int length() {
            return this.count;
        }
    }

    private final class BufferingHasher
    extends AbstractHasher {
        final ExposedByteArrayOutputStream stream;

        BufferingHasher(int n2) {
            this.stream = new ExposedByteArrayOutputStream(n2);
        }

        @Override
        public Hasher putByte(byte by2) {
            this.stream.write(by2);
            return this;
        }

        @Override
        public Hasher putBytes(byte[] byArray, int n2, int n3) {
            this.stream.write(byArray, n2, n3);
            return this;
        }

        @Override
        public HashCode hash() {
            return AbstractNonStreamingHashFunction.this.hashBytes(this.stream.byteArray(), 0, this.stream.length());
        }
    }
}

