/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.dev.failsafe;

import com.gradle.scan.plugin.internal.dep.dev.failsafe.ExecutionContext;
import com.gradle.scan.plugin.internal.dep.dev.failsafe.FailsafeException;
import com.gradle.scan.plugin.internal.dep.dev.failsafe.SyncExecutionImpl;
import com.gradle.scan.plugin.internal.dep.dev.failsafe.function.CheckedSupplier;
import com.gradle.scan.plugin.internal.dep.dev.failsafe.function.ContextualSupplier;
import com.gradle.scan.plugin.internal.dep.dev.failsafe.internal.util.Assert;
import com.gradle.scan.plugin.internal.dep.dev.failsafe.spi.AsyncExecutionInternal;
import com.gradle.scan.plugin.internal.dep.dev.failsafe.spi.ExecutionResult;
import com.gradle.scan.plugin.internal.dep.dev.failsafe.spi.FailsafeFuture;
import com.gradle.scan.plugin.internal.dep.dev.failsafe.spi.Scheduler;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;

final class Functions {
    static <R> Function<SyncExecutionImpl<R>, ExecutionResult<R>> get(ContextualSupplier<R, R> contextualSupplier, Executor executor) {
        return syncExecutionImpl -> {
            ExecutionResult<Object> executionResult;
            Throwable throwable = null;
            try {
                syncExecutionImpl.preExecute();
                executionResult = ExecutionResult.success(Functions.withExecutor(contextualSupplier, executor).get((ExecutionContext)syncExecutionImpl));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                executionResult = ExecutionResult.exception(throwable2);
            }
            syncExecutionImpl.record(executionResult);
            Object object = syncExecutionImpl.getLock();
            synchronized (object) {
                syncExecutionImpl.setInterruptable(false);
                if (syncExecutionImpl.isInterrupted()) {
                    Thread.interrupted();
                    return syncExecutionImpl.getResult();
                }
                if (throwable instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            return executionResult;
        };
    }

    static <R> Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> getPromiseOfStage(ContextualSupplier<R, ? extends CompletionStage<? extends R>> contextualSupplier, FailsafeFuture<R> failsafeFuture, Executor executor) {
        Assert.notNull(contextualSupplier, "supplier");
        return asyncExecutionInternal -> {
            CompletableFuture completableFuture = new CompletableFuture();
            try {
                asyncExecutionInternal.preExecute();
                CompletionStage completionStage = (CompletionStage)Functions.withExecutor(contextualSupplier, executor).get((ExecutionContext)asyncExecutionInternal);
                if (completionStage == null) {
                    ExecutionResult<Object> executionResult = ExecutionResult.success(null);
                    asyncExecutionInternal.record(executionResult);
                    completableFuture.complete(executionResult);
                } else {
                    if (completionStage instanceof Future) {
                        failsafeFuture.propagateCancellation((Future)((Object)completionStage));
                    }
                    completionStage.whenComplete((object, throwable) -> {
                        if (throwable instanceof CompletionException) {
                            throwable = throwable.getCause();
                        }
                        ExecutionResult<Object> executionResult = throwable == null ? ExecutionResult.success(object) : ExecutionResult.exception(throwable);
                        asyncExecutionInternal.record(executionResult);
                        completableFuture.complete(executionResult);
                    });
                }
            }
            catch (Throwable throwable2) {
                ExecutionResult executionResult = ExecutionResult.exception(throwable2);
                asyncExecutionInternal.record(executionResult);
                completableFuture.complete(executionResult);
            }
            return completableFuture;
        };
    }

    static <R> Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> toExecutionAware(Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> function) {
        return asyncExecutionInternal -> {
            ExecutionResult executionResult = asyncExecutionInternal.getResult();
            if (executionResult == null) {
                return (CompletableFuture)function.apply((AsyncExecutionInternal)asyncExecutionInternal);
            }
            return CompletableFuture.completedFuture(executionResult);
        };
    }

    static <R> Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> toAsync(Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> function, Scheduler scheduler, FailsafeFuture<R> failsafeFuture) {
        AtomicBoolean atomicBoolean = new AtomicBoolean();
        return asyncExecutionInternal -> {
            if (atomicBoolean.get()) {
                return (CompletableFuture)function.apply((AsyncExecutionInternal)asyncExecutionInternal);
            }
            CompletableFuture completableFuture = new CompletableFuture();
            Callable<Object> callable = () -> ((CompletableFuture)function.apply((AsyncExecutionInternal)asyncExecutionInternal)).whenComplete((executionResult, throwable) -> {
                if (throwable != null) {
                    completableFuture.completeExceptionally((Throwable)throwable);
                } else {
                    completableFuture.complete(executionResult);
                }
            });
            try {
                atomicBoolean.set(true);
                ScheduledFuture<?> scheduledFuture = scheduler.schedule(callable, 0L, TimeUnit.NANOSECONDS);
                failsafeFuture.setCancelFn(-1, (bl2, executionResult) -> {
                    scheduledFuture.cancel((boolean)bl2);
                    if (!asyncExecutionInternal.isPreExecuted()) {
                        completableFuture.complete(executionResult);
                    }
                });
            }
            catch (Throwable throwable) {
                completableFuture.completeExceptionally(throwable);
            }
            return completableFuture;
        };
    }

    static <R, T> ContextualSupplier<R, T> toCtxSupplier(CheckedSupplier<T> checkedSupplier) {
        Assert.notNull(checkedSupplier, "supplier");
        return executionContext -> checkedSupplier.get();
    }

    static <R, T> ContextualSupplier<R, T> withExecutor(ContextualSupplier<R, T> contextualSupplier, Executor executor) {
        return executor == null ? contextualSupplier : executionContext -> {
            executor.execute(() -> {
                try {
                    contextualSupplier.get(executionContext);
                }
                catch (Throwable throwable) {
                    Functions.handleExecutorThrowable(throwable);
                }
            });
            return null;
        };
    }

    private static void handleExecutorThrowable(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw new FailsafeException(throwable);
    }
}

