/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.buffer;

final class LongLongHashMap {
    private int mask;
    private long[] array;
    private int maxProbe;
    private long zeroVal;
    private final long emptyVal;

    LongLongHashMap(long l2) {
        this.emptyVal = l2;
        this.zeroVal = l2;
        int n2 = 32;
        this.array = new long[n2];
        this.mask = n2 - 1;
        this.computeMaskAndProbe();
    }

    public long put(long l2, long l3) {
        if (l2 == 0L) {
            long l4 = this.zeroVal;
            this.zeroVal = l3;
            return l4;
        }
        while (true) {
            int n2 = this.index(l2);
            for (int i2 = 0; i2 < this.maxProbe; ++i2) {
                long l5 = this.array[n2];
                if (l5 == l2 || l5 == 0L) {
                    long l6 = l5 == 0L ? this.emptyVal : this.array[n2 + 1];
                    this.array[n2] = l2;
                    this.array[n2 + 1] = l3;
                    while (i2 < this.maxProbe) {
                        if (this.array[n2 = n2 + 2 & this.mask] == l2) {
                            this.array[n2] = 0L;
                            l6 = this.array[n2 + 1];
                            break;
                        }
                        ++i2;
                    }
                    return l6;
                }
                n2 = n2 + 2 & this.mask;
            }
            this.expand();
        }
    }

    public void remove(long l2) {
        if (l2 == 0L) {
            this.zeroVal = this.emptyVal;
            return;
        }
        int n2 = this.index(l2);
        for (int i2 = 0; i2 < this.maxProbe; ++i2) {
            long l3 = this.array[n2];
            if (l3 == l2) {
                this.array[n2] = 0L;
                break;
            }
            n2 = n2 + 2 & this.mask;
        }
    }

    public long get(long l2) {
        if (l2 == 0L) {
            return this.zeroVal;
        }
        int n2 = this.index(l2);
        for (int i2 = 0; i2 < this.maxProbe; ++i2) {
            long l3 = this.array[n2];
            if (l3 == l2) {
                return this.array[n2 + 1];
            }
            n2 = n2 + 2 & this.mask;
        }
        return this.emptyVal;
    }

    private int index(long l2) {
        l2 ^= l2 >>> 33;
        l2 *= -49064778989728563L;
        l2 ^= l2 >>> 33;
        l2 *= -4265267296055464877L;
        l2 ^= l2 >>> 33;
        return (int)l2 & this.mask;
    }

    private void expand() {
        long[] lArray = this.array;
        this.array = new long[lArray.length * 2];
        this.computeMaskAndProbe();
        for (int i2 = 0; i2 < lArray.length; i2 += 2) {
            long l2 = lArray[i2];
            if (l2 == 0L) continue;
            long l3 = lArray[i2 + 1];
            this.put(l2, l3);
        }
    }

    private void computeMaskAndProbe() {
        int n2 = this.array.length;
        this.mask = n2 - 1 & 0xFFFFFFFE;
        this.maxProbe = (int)Math.log(n2);
    }
}

