/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl;

import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBufAllocator;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBufUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.AbstractCoalescingBufferQueue;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.Channel;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.PlatformDependent;

abstract class SslHandlerCoalescingBufferQueue
extends AbstractCoalescingBufferQueue {
    private final boolean wantsDirectBuffer;

    SslHandlerCoalescingBufferQueue(Channel channel, int n2, boolean bl2) {
        super(channel, n2);
        this.wantsDirectBuffer = bl2;
    }

    protected abstract int wrapDataSize();

    @Override
    protected ByteBuf compose(ByteBufAllocator byteBufAllocator, ByteBuf byteBuf, ByteBuf byteBuf2) {
        return SslHandlerCoalescingBufferQueue.attemptCopyToCumulation(byteBuf, byteBuf2, this.wrapDataSize()) ? byteBuf : this.copyAndCompose(byteBufAllocator, byteBuf, byteBuf2);
    }

    @Override
    protected ByteBuf composeFirst(ByteBufAllocator byteBufAllocator, ByteBuf byteBuf, int n2) {
        ByteBuf byteBuf2 = this.wantsDirectBuffer ? byteBufAllocator.directBuffer(n2) : byteBufAllocator.heapBuffer(n2);
        try {
            byteBuf2.writeBytes(byteBuf);
        }
        catch (Throwable throwable) {
            byteBuf2.release();
            PlatformDependent.throwException(throwable);
        }
        assert (!byteBuf.isReadable());
        byteBuf.release();
        return byteBuf2;
    }

    @Override
    protected ByteBuf removeEmptyValue() {
        return null;
    }

    private static boolean attemptCopyToCumulation(ByteBuf byteBuf, ByteBuf byteBuf2, int n2) {
        int n3 = byteBuf2.readableBytes();
        if (n3 == 0) {
            byteBuf2.release();
            return true;
        }
        int n4 = byteBuf.capacity();
        if (n2 - byteBuf.readableBytes() >= n3 && (byteBuf.isWritable(n3) && n4 >= n2 || n4 < n2 && ByteBufUtil.ensureWritableSuccess(byteBuf.ensureWritable(n3, false)))) {
            byteBuf.writeBytes(byteBuf2);
            byteBuf2.release();
            return true;
        }
        return false;
    }
}

