/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl;

import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBufAllocator;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBufUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelHandlerContext;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.base64.Base64;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.base64.Base64Dialect;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.SslHandshakeCompletionEvent;
import com.gradle.scan.plugin.internal.dep.io.netty.util.NetUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.EmptyArrays;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.StringUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.TrustManager;

final class SslUtils {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SslUtils.class);
    static final Set<String> TLSV13_CIPHERS = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("TLS_AES_256_GCM_SHA384", "TLS_CHACHA20_POLY1305_SHA256", "TLS_AES_128_GCM_SHA256", "TLS_AES_128_CCM_8_SHA256", "TLS_AES_128_CCM_SHA256")));
    static final String[] DEFAULT_CIPHER_SUITES;
    static final String[] DEFAULT_TLSV13_CIPHER_SUITES;
    static final String[] TLSV13_CIPHER_SUITES;
    private static final boolean TLSV1_3_JDK_SUPPORTED;
    private static final boolean TLSV1_3_JDK_DEFAULT_ENABLED;

    static boolean isTLSv13SupportedByJDK(Provider provider) {
        if (provider == null) {
            return TLSV1_3_JDK_SUPPORTED;
        }
        return SslUtils.isTLSv13SupportedByJDK0(provider);
    }

    private static boolean isTLSv13SupportedByJDK0(Provider provider) {
        try {
            return SslUtils.arrayContains(SslUtils.newInitContext(provider).getSupportedSSLParameters().getProtocols(), "TLSv1.3");
        }
        catch (Throwable throwable) {
            logger.debug("Unable to detect if JDK SSLEngine with provider {} supports TLSv1.3, assuming no", (Object)provider, (Object)throwable);
            return false;
        }
    }

    private static boolean isTLSv13EnabledByJDK0(Provider provider) {
        try {
            return SslUtils.arrayContains(SslUtils.newInitContext(provider).getDefaultSSLParameters().getProtocols(), "TLSv1.3");
        }
        catch (Throwable throwable) {
            logger.debug("Unable to detect if JDK SSLEngine with provider {} enables TLSv1.3 by default, assuming no", (Object)provider, (Object)throwable);
            return false;
        }
    }

    private static SSLContext newInitContext(Provider provider) throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sSLContext = provider == null ? SSLContext.getInstance("TLS") : SSLContext.getInstance("TLS", provider);
        sSLContext.init(null, new TrustManager[0], null);
        return sSLContext;
    }

    static SSLContext getSSLContext(String string) throws NoSuchAlgorithmException, KeyManagementException, NoSuchProviderException {
        SSLContext sSLContext = StringUtil.isNullOrEmpty(string) ? SSLContext.getInstance(SslUtils.getTlsVersion()) : SSLContext.getInstance(SslUtils.getTlsVersion(), string);
        sSLContext.init(null, new TrustManager[0], null);
        return sSLContext;
    }

    private static String getTlsVersion() {
        return TLSV1_3_JDK_SUPPORTED ? "TLSv1.3" : "TLSv1.2";
    }

    static boolean arrayContains(String[] stringArray, String string) {
        for (String string2 : stringArray) {
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    static void addIfSupported(Set<String> set, List<String> list, String ... stringArray) {
        for (String string : stringArray) {
            if (!set.contains(string)) continue;
            list.add(string);
        }
    }

    static void useFallbackCiphersIfDefaultIsEmpty(List<String> list, Iterable<String> iterable) {
        if (list.isEmpty()) {
            for (String string : iterable) {
                if (string.startsWith("SSL_") || string.contains("_RC4_")) continue;
                list.add(string);
            }
        }
    }

    static void useFallbackCiphersIfDefaultIsEmpty(List<String> list, String ... stringArray) {
        SslUtils.useFallbackCiphersIfDefaultIsEmpty(list, Arrays.asList(stringArray));
    }

    static SSLHandshakeException toSSLHandshakeException(Throwable throwable) {
        if (throwable instanceof SSLHandshakeException) {
            return (SSLHandshakeException)throwable;
        }
        return (SSLHandshakeException)new SSLHandshakeException(throwable.getMessage()).initCause(throwable);
    }

    static int getEncryptedPacketLength(ByteBuf byteBuf, int n2, boolean bl2) {
        short s2;
        int n3;
        boolean bl3;
        int n4 = 0;
        switch (byteBuf.getUnsignedByte(n2)) {
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                bl3 = true;
                break;
            }
            default: {
                if (!bl2) {
                    return -2;
                }
                bl3 = false;
            }
        }
        if (bl3) {
            n3 = byteBuf.getUnsignedByte(n2 + 1);
            s2 = byteBuf.getShort(n2 + 1);
            if (n3 == 3 || s2 == 257) {
                n4 = SslUtils.unsignedShortBE(byteBuf, n2 + 3) + 5;
                if (n4 <= 5) {
                    bl3 = false;
                }
            } else if (s2 == -257 || s2 == -259 || s2 == -260) {
                if (byteBuf.readableBytes() < n2 + 13) {
                    return -1;
                }
                n4 = SslUtils.unsignedShortBE(byteBuf, n2 + 13 - 2) + 13;
            } else {
                bl3 = false;
            }
        }
        if (!bl3) {
            n3 = (byteBuf.getUnsignedByte(n2) & 0x80) != 0 ? 2 : 3;
            s2 = byteBuf.getUnsignedByte(n2 + n3 + 1);
            if (s2 == 2 || s2 == 3) {
                int n5 = n4 = n3 == 2 ? (SslUtils.shortBE(byteBuf, n2) & Short.MAX_VALUE) + 2 : (SslUtils.shortBE(byteBuf, n2) & 0x3FFF) + 3;
                if (n4 <= n3) {
                    return -1;
                }
            } else {
                return -2;
            }
        }
        return n4;
    }

    private static int unsignedShortBE(ByteBuf byteBuf, int n2) {
        int n3 = byteBuf.getUnsignedShort(n2);
        if (byteBuf.order() == ByteOrder.LITTLE_ENDIAN) {
            n3 = Integer.reverseBytes(n3) >>> 16;
        }
        return n3;
    }

    private static short shortBE(ByteBuf byteBuf, int n2) {
        short s2 = byteBuf.getShort(n2);
        if (byteBuf.order() == ByteOrder.LITTLE_ENDIAN) {
            s2 = Short.reverseBytes(s2);
        }
        return s2;
    }

    private static short unsignedByte(byte by2) {
        return (short)(by2 & 0xFF);
    }

    private static int unsignedShortBE(ByteBuffer byteBuffer, int n2) {
        return SslUtils.shortBE(byteBuffer, n2) & 0xFFFF;
    }

    private static short shortBE(ByteBuffer byteBuffer, int n2) {
        return byteBuffer.order() == ByteOrder.BIG_ENDIAN ? byteBuffer.getShort(n2) : ByteBufUtil.swapShort(byteBuffer.getShort(n2));
    }

    static int getEncryptedPacketLength(ByteBuffer[] byteBufferArray, int n2) {
        ByteBuffer byteBuffer = byteBufferArray[n2];
        if (byteBuffer.remaining() >= 5) {
            return SslUtils.getEncryptedPacketLength(byteBuffer);
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(5);
        do {
            if ((byteBuffer = byteBufferArray[n2++].duplicate()).remaining() > byteBuffer2.remaining()) {
                byteBuffer.limit(byteBuffer.position() + byteBuffer2.remaining());
            }
            byteBuffer2.put(byteBuffer);
        } while (byteBuffer2.hasRemaining());
        byteBuffer2.flip();
        return SslUtils.getEncryptedPacketLength(byteBuffer2);
    }

    private static int getEncryptedPacketLength(ByteBuffer byteBuffer) {
        int n2;
        boolean bl2;
        int n3 = 0;
        int n4 = byteBuffer.position();
        switch (SslUtils.unsignedByte(byteBuffer.get(n4))) {
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                bl2 = true;
                break;
            }
            default: {
                bl2 = false;
            }
        }
        if (bl2) {
            n2 = SslUtils.unsignedByte(byteBuffer.get(n4 + 1));
            if (n2 == 3 || byteBuffer.getShort(n4 + 1) == 257) {
                n3 = SslUtils.unsignedShortBE(byteBuffer, n4 + 3) + 5;
                if (n3 <= 5) {
                    bl2 = false;
                }
            } else {
                bl2 = false;
            }
        }
        if (!bl2) {
            n2 = (SslUtils.unsignedByte(byteBuffer.get(n4)) & 0x80) != 0 ? 2 : 3;
            short s2 = SslUtils.unsignedByte(byteBuffer.get(n4 + n2 + 1));
            if (s2 == 2 || s2 == 3) {
                int n5 = n3 = n2 == 2 ? (SslUtils.shortBE(byteBuffer, n4) & Short.MAX_VALUE) + 2 : (SslUtils.shortBE(byteBuffer, n4) & 0x3FFF) + 3;
                if (n3 <= n2) {
                    return -1;
                }
            } else {
                return -2;
            }
        }
        return n3;
    }

    static void handleHandshakeFailure(ChannelHandlerContext channelHandlerContext, Throwable throwable, boolean bl2) {
        channelHandlerContext.flush();
        if (bl2) {
            channelHandlerContext.fireUserEventTriggered(new SslHandshakeCompletionEvent(throwable));
        }
        channelHandlerContext.close();
    }

    static void zeroout(ByteBuf byteBuf) {
        if (!byteBuf.isReadOnly()) {
            byteBuf.setZero(0, byteBuf.capacity());
        }
    }

    static void zerooutAndRelease(ByteBuf byteBuf) {
        SslUtils.zeroout(byteBuf);
        byteBuf.release();
    }

    static ByteBuf toBase64(ByteBufAllocator byteBufAllocator, ByteBuf byteBuf) {
        ByteBuf byteBuf2 = Base64.encode(byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes(), true, Base64Dialect.STANDARD, byteBufAllocator);
        byteBuf.readerIndex(byteBuf.writerIndex());
        return byteBuf2;
    }

    static boolean isValidHostNameForSNI(String string) {
        return string != null && string.indexOf(46) > 0 && !string.endsWith(".") && !string.startsWith("/") && !NetUtil.isValidIpV4Address(string) && !NetUtil.isValidIpV6Address(string);
    }

    static boolean isTLSv13Cipher(String string) {
        return TLSV13_CIPHERS.contains(string);
    }

    private SslUtils() {
    }

    static {
        TLSV13_CIPHER_SUITES = new String[]{"TLS_AES_128_GCM_SHA256", "TLS_AES_256_GCM_SHA384"};
        TLSV1_3_JDK_SUPPORTED = SslUtils.isTLSv13SupportedByJDK0(null);
        TLSV1_3_JDK_DEFAULT_ENABLED = SslUtils.isTLSv13EnabledByJDK0(null);
        DEFAULT_TLSV13_CIPHER_SUITES = TLSV1_3_JDK_SUPPORTED ? TLSV13_CIPHER_SUITES : EmptyArrays.EMPTY_STRINGS;
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        linkedHashSet.add("TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384");
        linkedHashSet.add("TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256");
        linkedHashSet.add("TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256");
        linkedHashSet.add("TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384");
        linkedHashSet.add("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA");
        linkedHashSet.add("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA");
        linkedHashSet.add("TLS_RSA_WITH_AES_128_GCM_SHA256");
        linkedHashSet.add("TLS_RSA_WITH_AES_128_CBC_SHA");
        linkedHashSet.add("TLS_RSA_WITH_AES_256_CBC_SHA");
        Collections.addAll(linkedHashSet, DEFAULT_TLSV13_CIPHER_SUITES);
        DEFAULT_CIPHER_SUITES = linkedHashSet.toArray(EmptyArrays.EMPTY_STRINGS);
    }
}

