/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.apache.commons.compress.archivers.zip;

import com.gradle.scan.plugin.internal.dep.org.apache.commons.compress.archivers.zip.NioZipEncoding;
import com.gradle.scan.plugin.internal.dep.org.apache.commons.compress.archivers.zip.ZipEncoding;
import com.gradle.scan.plugin.internal.dep.org.apache.commons.io.Charsets;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;

public abstract class ZipEncodingHelper {
    static final ZipEncoding ZIP_ENCODING_UTF_8 = ZipEncodingHelper.getZipEncoding(StandardCharsets.UTF_8);

    public static ZipEncoding getZipEncoding(Charset charset) {
        return new NioZipEncoding(Charsets.toCharset(charset), ZipEncodingHelper.isUTF8(Charsets.toCharset(charset)));
    }

    public static ZipEncoding getZipEncoding(String string) {
        return new NioZipEncoding(ZipEncodingHelper.toSafeCharset(string), ZipEncodingHelper.isUTF8(ZipEncodingHelper.toSafeCharset(string).name()));
    }

    static ByteBuffer growBufferBy(ByteBuffer byteBuffer, int n2) {
        byteBuffer.limit(byteBuffer.position());
        byteBuffer.rewind();
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(byteBuffer.capacity() + n2);
        byteBuffer2.put(byteBuffer);
        return byteBuffer2;
    }

    static boolean isUTF8(Charset charset) {
        return ZipEncodingHelper.isUTF8Alias(Charsets.toCharset(charset).name());
    }

    static boolean isUTF8(String string) {
        return ZipEncodingHelper.isUTF8Alias(string != null ? string : Charset.defaultCharset().name());
    }

    private static boolean isUTF8Alias(String string) {
        return StandardCharsets.UTF_8.name().equalsIgnoreCase(string) || StandardCharsets.UTF_8.aliases().stream().anyMatch(string2 -> string2.equalsIgnoreCase(string));
    }

    private static Charset toSafeCharset(String string) {
        Charset charset = Charset.defaultCharset();
        try {
            charset = Charsets.toCharset(string);
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            // empty catch block
        }
        return charset;
    }
}

