/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.apache.http.util;

import com.gradle.scan.plugin.internal.dep.org.apache.http.util.Args;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;

public class VersionInfo {
    private final String infoPackage;
    private final String infoModule;
    private final String infoRelease;
    private final String infoTimestamp;
    private final String infoClassloader;

    protected VersionInfo(String string, String string2, String string3, String string4, String string5) {
        Args.notNull(string, "Package identifier");
        this.infoPackage = string;
        this.infoModule = string2 != null ? string2 : "UNAVAILABLE";
        this.infoRelease = string3 != null ? string3 : "UNAVAILABLE";
        this.infoTimestamp = string4 != null ? string4 : "UNAVAILABLE";
        this.infoClassloader = string5 != null ? string5 : "UNAVAILABLE";
    }

    public final String getRelease() {
        return this.infoRelease;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(20 + this.infoPackage.length() + this.infoModule.length() + this.infoRelease.length() + this.infoTimestamp.length() + this.infoClassloader.length());
        stringBuilder.append("VersionInfo(").append(this.infoPackage).append(':').append(this.infoModule);
        if (!"UNAVAILABLE".equals(this.infoRelease)) {
            stringBuilder.append(':').append(this.infoRelease);
        }
        if (!"UNAVAILABLE".equals(this.infoTimestamp)) {
            stringBuilder.append(':').append(this.infoTimestamp);
        }
        stringBuilder.append(')');
        if (!"UNAVAILABLE".equals(this.infoClassloader)) {
            stringBuilder.append('@').append(this.infoClassloader);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VersionInfo loadVersionInfo(String string, ClassLoader classLoader) {
        Object object;
        Properties properties;
        ClassLoader classLoader2;
        block6: {
            Args.notNull(string, "Package identifier");
            classLoader2 = classLoader != null ? classLoader : Thread.currentThread().getContextClassLoader();
            properties = null;
            try {
                object = classLoader2.getResourceAsStream(string.replace('.', '/') + "/" + "version.properties");
                if (object == null) break block6;
                try {
                    Properties properties2 = new Properties();
                    properties2.load((InputStream)object);
                    properties = properties2;
                }
                finally {
                    ((InputStream)object).close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        object = null;
        if (properties != null) {
            object = VersionInfo.fromMap(string, properties, classLoader2);
        }
        return object;
    }

    protected static VersionInfo fromMap(String string, Map<?, ?> map, ClassLoader classLoader) {
        Args.notNull(string, "Package identifier");
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (map != null) {
            string2 = (String)map.get("info.module");
            if (string2 != null && string2.length() < 1) {
                string2 = null;
            }
            if ((string3 = (String)map.get("info.release")) != null && (string3.length() < 1 || string3.equals("${pom.version}"))) {
                string3 = null;
            }
            if ((string4 = (String)map.get("info.timestamp")) != null && (string4.length() < 1 || string4.equals("${mvn.timestamp}"))) {
                string4 = null;
            }
        }
        String string5 = null;
        if (classLoader != null) {
            string5 = classLoader.toString();
        }
        return new VersionInfo(string, string2, string3, string4, string5);
    }

    public static String getUserAgent(String string, String string2, Class<?> clazz) {
        VersionInfo versionInfo = VersionInfo.loadVersionInfo(string2, clazz.getClassLoader());
        String string3 = versionInfo != null ? versionInfo.getRelease() : "UNAVAILABLE";
        String string4 = System.getProperty("java.version");
        return String.format("%s/%s (Java/%s)", string, string3, string4);
    }
}

