/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.filter;

import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.filter.AnnotationInspector;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.testsreader.TestsReader;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.org.objectweb.asm.AnnotationVisitor;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class AnnotationInspectorImpl
implements AnnotationInspector {
    private static final Logger LOGGER = Logging.getLogger(AnnotationInspectorImpl.class);
    private final Map<String, Set<String>> cache = new HashMap<String, Set<String>>();
    private final Map<String, Boolean> inheritedCache = new HashMap<String, Boolean>();
    private final TestsReader testsReader;

    public AnnotationInspectorImpl(TestsReader testsReader) {
        this.testsReader = testsReader;
    }

    @Override
    public Set<String> getClassAnnotations(String string) {
        Set set = this.cache.get(string);
        if (set == null) {
            set = this.testsReader.readClass(string, () -> new ClassAnnotationVisitor()).orElseGet(() -> {
                LOGGER.warn("Unable to find annotations of " + string);
                return Collections.emptySet();
            });
            this.cache.put(string, set);
        }
        return set;
    }

    private boolean isInherited(String string) {
        return this.inheritedCache.computeIfAbsent(string, string2 -> this.testsReader.readClass(string, AnnotationAnnotationVisitor::new).orElseGet(() -> {
            LOGGER.warn("Cannot determine whether @" + string + " is inherited");
            return false;
        }));
    }

    private static String classDescriptorToClassName(String string) {
        return string.substring(1, string.length() - 1).replace('/', '.');
    }

    static final class AnnotationAnnotationVisitor
    extends TestsReader.Visitor<Boolean> {
        private boolean inherited;

        AnnotationAnnotationVisitor() {
        }

        @Override
        public Boolean getResult() {
            return this.inherited;
        }

        @Override
        public AnnotationVisitor visitAnnotation(String string, boolean bl2) {
            if (string.equals("Ljava/lang/annotation/Inherited;")) {
                this.inherited = true;
            }
            return null;
        }
    }

    final class ClassAnnotationVisitor
    extends TestsReader.Visitor<Set<String>> {
        private final Set<String> found = new HashSet<String>();

        ClassAnnotationVisitor() {
        }

        @Override
        public Set<String> getResult() {
            return this.found.isEmpty() ? Collections.emptySet() : this.found;
        }

        @Override
        public void visit(int n2, int n3, String string2, String string3, String string4, String[] stringArray) {
            if (!string4.equals("java/lang/Object")) {
                AnnotationInspectorImpl.this.getClassAnnotations(string4.replace('/', '.')).stream().filter(string -> AnnotationInspectorImpl.this.isInherited(string)).forEach(this.found::add);
            }
        }

        @Override
        public AnnotationVisitor visitAnnotation(String string, boolean bl2) {
            this.found.add(AnnotationInspectorImpl.classDescriptorToClassName(string));
            return null;
        }
    }
}

