/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.filter;

import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.filter.AnnotationInspector;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.filter.GlobPattern;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;

public class RetryFilter {
    private final AnnotationInspector annotationInspector;
    private final Set<GlobPattern> includeClasses;
    private final Set<GlobPattern> includeAnnotationClasses;
    private final Set<GlobPattern> excludeClasses;
    private final Set<GlobPattern> excludeAnnotationClasses;

    public RetryFilter(AnnotationInspector annotationInspector, Collection<String> collection, Collection<String> collection2, Collection<String> collection3, Collection<String> collection4) {
        this.annotationInspector = annotationInspector;
        this.includeClasses = RetryFilter.toPatterns(collection);
        this.includeAnnotationClasses = RetryFilter.toPatterns(collection2);
        this.excludeClasses = RetryFilter.toPatterns(collection3);
        this.excludeAnnotationClasses = RetryFilter.toPatterns(collection4);
    }

    public boolean canRetry(String string) {
        if (!this.includeClasses.isEmpty() && !RetryFilter.anyMatch(this.includeClasses, string)) {
            return false;
        }
        if (RetryFilter.anyMatch(this.excludeClasses, string)) {
            return false;
        }
        Set<String> set = null;
        if (!(this.includeAnnotationClasses.isEmpty() || !(set = this.annotationInspector.getClassAnnotations(string)).isEmpty() && RetryFilter.anyMatch(this.includeAnnotationClasses, set))) {
            return false;
        }
        if (!this.excludeAnnotationClasses.isEmpty()) {
            set = set == null ? this.annotationInspector.getClassAnnotations(string) : set;
            return !RetryFilter.anyMatch(this.excludeAnnotationClasses, set);
        }
        return true;
    }

    private static boolean anyMatch(Set<GlobPattern> set, String string) {
        return RetryFilter.anyMatch(set, Collections.singleton(string));
    }

    private static boolean anyMatch(Set<GlobPattern> set, Set<String> set2) {
        return set.stream().anyMatch(globPattern -> set2.stream().anyMatch(globPattern::matches));
    }

    private static Set<GlobPattern> toPatterns(Collection<String> collection) {
        return collection.stream().map(GlobPattern::from).collect(Collectors.toSet());
    }
}

