/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.oshi.driver.unix.solaris;

import com.gradle.scan.plugin.internal.dep.oshi.jna.platform.unix.SolarisLibc;
import com.gradle.scan.plugin.internal.dep.oshi.util.ExecutingCommand;
import com.gradle.scan.plugin.internal.dep.oshi.util.FileUtil;
import com.gradle.scan.plugin.internal.dep.oshi.util.ParseUtil;
import com.gradle.scan.plugin.internal.dep.oshi.util.tuples.Pair;
import com.gradle.scan.plugin.internal.dep.oshi.util.tuples.Quartet;
import com.sun.jna.Memory;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.platform.unix.LibCAPI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PsInfo {
    private static final Logger LOG = LoggerFactory.getLogger(PsInfo.class);
    private static final SolarisLibc LIBC = SolarisLibc.INSTANCE;
    private static final long PAGE_SIZE = ParseUtil.parseLongOrDefault(ExecutingCommand.getFirstAnswer("pagesize"), 4096L);

    private PsInfo() {
    }

    public static SolarisLibc.SolarisPsInfo queryPsInfo(int n2) {
        return new SolarisLibc.SolarisPsInfo(FileUtil.readAllBytesAsBuffer(String.format(Locale.ROOT, "/proc/%d/psinfo", n2)));
    }

    public static SolarisLibc.SolarisPrUsage queryPrUsage(int n2) {
        return new SolarisLibc.SolarisPrUsage(FileUtil.readAllBytesAsBuffer(String.format(Locale.ROOT, "/proc/%d/usage", n2)));
    }

    public static Quartet<Integer, Long, Long, Byte> queryArgsEnvAddrs(int n2, SolarisLibc.SolarisPsInfo solarisPsInfo) {
        if (solarisPsInfo != null) {
            int n3 = solarisPsInfo.pr_argc;
            if (n3 > 0) {
                long l2 = Pointer.nativeValue(solarisPsInfo.pr_argv);
                byte by2 = solarisPsInfo.pr_dmodel;
                long l3 = Pointer.nativeValue(solarisPsInfo.pr_envp);
                if ((long)(by2 * 4) == (l3 - l2) / (long)(n3 + 1)) {
                    return new Quartet<Integer, Long, Long, Byte>(n3, l2, l3, by2);
                }
                LOG.trace("Failed data model and offset increment sanity check: dm={} diff={}", (Object)by2, (Object)(l3 - l2));
                return null;
            }
            LOG.trace("Failed argc sanity check: argc={}", (Object)n3);
            return null;
        }
        LOG.trace("Failed to read psinfo file for pid: {} ", (Object)n2);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pair<List<String>, Map<String, String>> queryArgsEnv(int n2, SolarisLibc.SolarisPsInfo solarisPsInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        Quartet<Integer, Long, Long, Byte> quartet = PsInfo.queryArgsEnvAddrs(n2, solarisPsInfo);
        if (quartet != null) {
            String string = "/proc/" + n2 + "/as";
            int n3 = LIBC.open(string, 0);
            if (n3 < 0) {
                LOG.trace("No permission to read file: {} ", (Object)string);
                return new Pair<List<String>, Map<String, String>>(arrayList, linkedHashMap);
            }
            try {
                int n4 = quartet.getA();
                long l2 = quartet.getB();
                long l3 = quartet.getC();
                long l4 = (long)quartet.getD().byteValue() * 4L;
                long l5 = 0L;
                try (Memory memory = new Memory(PAGE_SIZE * 2L);){
                    LibCAPI.size_t size_t2 = new LibCAPI.size_t(memory.size());
                    long[] lArray = new long[n4];
                    long l6 = l2;
                    for (int i2 = 0; i2 < n4; ++i2) {
                        lArray[i2] = (l5 = PsInfo.conditionallyReadBufferFromStartOfPage(n3, memory, size_t2, l5, l6)) == 0L ? 0L : PsInfo.getOffsetFromBuffer(memory, l6 - l5, l4);
                        l6 += l4;
                    }
                    ArrayList<Long> arrayList2 = new ArrayList<Long>();
                    l6 = l3;
                    long l7 = 0L;
                    int n5 = 500;
                    do {
                        long l8 = l7 = (l5 = PsInfo.conditionallyReadBufferFromStartOfPage(n3, memory, size_t2, l5, l6)) == 0L ? 0L : PsInfo.getOffsetFromBuffer(memory, l6 - l5, l4);
                        if (l7 != 0L) {
                            arrayList2.add(l7);
                        }
                        l6 += l4;
                    } while (l7 != 0L && --n5 > 0);
                    for (int i3 = 0; i3 < lArray.length && lArray[i3] != 0L; ++i3) {
                        String object;
                        if ((l5 = PsInfo.conditionallyReadBufferFromStartOfPage(n3, memory, size_t2, l5, lArray[i3])) == 0L || (object = memory.getString(lArray[i3] - l5)).isEmpty()) continue;
                        arrayList.add(object);
                    }
                    for (Long l9 : arrayList2) {
                        String string2;
                        int n6;
                        if ((l5 = PsInfo.conditionallyReadBufferFromStartOfPage(n3, memory, size_t2, l5, l9)) == 0L || (n6 = (string2 = memory.getString(l9 - l5)).indexOf(61)) <= 0) continue;
                        linkedHashMap.put(string2.substring(0, n6), string2.substring(n6 + 1));
                    }
                }
            }
            finally {
                LIBC.close(n3);
            }
        }
        return new Pair<List<String>, Map<String, String>>(arrayList, linkedHashMap);
    }

    private static long conditionallyReadBufferFromStartOfPage(int n2, Memory memory, LibCAPI.size_t size_t2, long l2, long l3) {
        if (l3 < l2 || l3 - l2 > PAGE_SIZE) {
            long l4 = Math.floorDiv(l3, PAGE_SIZE) * PAGE_SIZE;
            LibCAPI.ssize_t ssize_t2 = LIBC.pread(n2, memory, size_t2, new NativeLong(l4));
            if (ssize_t2.longValue() < PAGE_SIZE) {
                LOG.debug("Failed to read page from address space: {} bytes read", (Object)ssize_t2.longValue());
                return 0L;
            }
            return l4;
        }
        return l2;
    }

    private static long getOffsetFromBuffer(Memory memory, long l2, long l3) {
        return l3 == 8L ? memory.getLong(l2) : (long)memory.getInt(l2);
    }
}

