/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.oshi.hardware.platform.windows;

import com.gradle.scan.plugin.internal.dep.oshi.hardware.VirtualMemory;
import com.gradle.scan.plugin.internal.dep.oshi.hardware.common.AbstractGlobalMemory;
import com.gradle.scan.plugin.internal.dep.oshi.hardware.platform.windows.WindowsVirtualMemory;
import com.gradle.scan.plugin.internal.dep.oshi.jna.Struct;
import com.gradle.scan.plugin.internal.dep.oshi.util.Memoizer;
import com.gradle.scan.plugin.internal.dep.oshi.util.tuples.Triplet;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Psapi;
import com.sun.jna.platform.win32.VersionHelpers;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class WindowsGlobalMemory
extends AbstractGlobalMemory {
    private static final Logger LOG = LoggerFactory.getLogger(WindowsGlobalMemory.class);
    private static final boolean IS_WINDOWS10_OR_GREATER = VersionHelpers.IsWindows10OrGreater();
    private final Supplier<Triplet<Long, Long, Long>> availTotalSize = Memoizer.memoize(WindowsGlobalMemory::readPerfInfo, Memoizer.defaultExpiration());
    private final Supplier<VirtualMemory> vm = Memoizer.memoize(this::createVirtualMemory);

    WindowsGlobalMemory() {
    }

    @Override
    public long getAvailable() {
        return this.availTotalSize.get().getA();
    }

    @Override
    public long getTotal() {
        return this.availTotalSize.get().getB();
    }

    public long getPageSize() {
        return this.availTotalSize.get().getC();
    }

    private VirtualMemory createVirtualMemory() {
        return new WindowsVirtualMemory(this);
    }

    private static Triplet<Long, Long, Long> readPerfInfo() {
        try (Struct.CloseablePerformanceInformation closeablePerformanceInformation = new Struct.CloseablePerformanceInformation();){
            if (!Psapi.INSTANCE.GetPerformanceInfo(closeablePerformanceInformation, closeablePerformanceInformation.size())) {
                LOG.error("Failed to get Performance Info. Error code: {}", (Object)Kernel32.INSTANCE.GetLastError());
                Triplet<Long, Long, Long> triplet = new Triplet<Long, Long, Long>(0L, 0L, 4098L);
                return triplet;
            }
            long l2 = closeablePerformanceInformation.PageSize.longValue();
            long l3 = l2 * closeablePerformanceInformation.PhysicalAvailable.longValue();
            long l4 = l2 * closeablePerformanceInformation.PhysicalTotal.longValue();
            Triplet<Long, Long, Long> triplet = new Triplet<Long, Long, Long>(l3, l4, l2);
            return triplet;
        }
    }
}

