/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.oshi.util.platform.unix.solaris;

import com.gradle.scan.plugin.internal.dep.oshi.software.os.unix.solaris.SolarisOperatingSystem;
import com.gradle.scan.plugin.internal.dep.oshi.util.FormatUtil;
import com.gradle.scan.plugin.internal.dep.oshi.util.Util;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.unix.solaris.Kstat2;
import com.sun.jna.platform.unix.solaris.Kstat2StatusException;
import com.sun.jna.platform.unix.solaris.LibKstat;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KstatUtil {
    private static final Logger LOG = LoggerFactory.getLogger(KstatUtil.class);
    private static final Lock CHAIN = new ReentrantLock();
    private static LibKstat.KstatCtl kstatCtl = null;

    private KstatUtil() {
    }

    public static synchronized KstatChain openChain() {
        CHAIN.lock();
        if (kstatCtl == null) {
            kstatCtl = LibKstat.INSTANCE.kstat_open();
        }
        return new KstatChain(kstatCtl);
    }

    public static String dataLookupString(LibKstat.Kstat kstat, String string) {
        if (kstat.ks_type != 1 && kstat.ks_type != 4) {
            throw new IllegalArgumentException("Not a kstat_named or kstat_timer kstat.");
        }
        Pointer pointer = LibKstat.INSTANCE.kstat_data_lookup(kstat, string);
        if (pointer == null) {
            LOG.debug("Failed to lookup kstat value for key {}", (Object)string);
            return "";
        }
        LibKstat.KstatNamed kstatNamed = new LibKstat.KstatNamed(pointer);
        switch (kstatNamed.data_type) {
            case 0: {
                return Native.toString(kstatNamed.value.charc, StandardCharsets.UTF_8);
            }
            case 1: {
                return Integer.toString(kstatNamed.value.i32);
            }
            case 2: {
                return FormatUtil.toUnsignedString(kstatNamed.value.ui32);
            }
            case 3: {
                return Long.toString(kstatNamed.value.i64);
            }
            case 4: {
                return FormatUtil.toUnsignedString(kstatNamed.value.ui64);
            }
            case 9: {
                return kstatNamed.value.str.addr.getString(0L);
            }
        }
        LOG.error("Unimplemented kstat data type {}", (Object)kstatNamed.data_type);
        return "";
    }

    public static long dataLookupLong(LibKstat.Kstat kstat, String string) {
        if (kstat.ks_type != 1 && kstat.ks_type != 4) {
            throw new IllegalArgumentException("Not a kstat_named or kstat_timer kstat.");
        }
        Pointer pointer = LibKstat.INSTANCE.kstat_data_lookup(kstat, string);
        if (pointer == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Failed lo lookup kstat value on {}:{}:{} for key {}", new Object[]{Native.toString(kstat.ks_module, StandardCharsets.US_ASCII), kstat.ks_instance, Native.toString(kstat.ks_name, StandardCharsets.US_ASCII), string});
            }
            return 0L;
        }
        LibKstat.KstatNamed kstatNamed = new LibKstat.KstatNamed(pointer);
        switch (kstatNamed.data_type) {
            case 1: {
                return kstatNamed.value.i32;
            }
            case 2: {
                return FormatUtil.getUnsignedInt(kstatNamed.value.ui32);
            }
            case 3: {
                return kstatNamed.value.i64;
            }
            case 4: {
                return kstatNamed.value.ui64;
            }
        }
        LOG.error("Unimplemented or non-numeric kstat data type {}", (Object)kstatNamed.data_type);
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object[] queryKstat2(String string, String ... stringArray) {
        if (!SolarisOperatingSystem.HAS_KSTAT2) {
            throw new UnsupportedOperationException("Kstat2 requires Solaris 11.4+. Use SolarisOperatingSystem#HAS_KSTAT2 to test this.");
        }
        Object[] objectArray = new Object[stringArray.length];
        Kstat2.Kstat2MatcherList kstat2MatcherList = new Kstat2.Kstat2MatcherList();
        CHAIN.lock();
        try {
            kstat2MatcherList.addMatcher(0, string);
            try (Kstat2.Kstat2Handle kstat2Handle = new Kstat2.Kstat2Handle();){
                Kstat2.Kstat2Map kstat2Map = kstat2Handle.lookupMap(string);
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    objectArray[i2] = kstat2Map.getValue(stringArray[i2]);
                }
            }
        }
        catch (Kstat2StatusException kstat2StatusException) {
            LOG.debug("Failed to get stats on {} for names {}: {}", new Object[]{string, Arrays.toString(stringArray), kstat2StatusException.getMessage()});
        }
        finally {
            CHAIN.unlock();
            kstat2MatcherList.free();
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Object[]> queryKstat2List(String string, String string2, String ... stringArray) {
        if (!SolarisOperatingSystem.HAS_KSTAT2) {
            throw new UnsupportedOperationException("Kstat2 requires Solaris 11.4+. Use SolarisOperatingSystem#HAS_KSTAT2 to test this.");
        }
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        int n2 = 0;
        Kstat2.Kstat2MatcherList kstat2MatcherList = new Kstat2.Kstat2MatcherList();
        CHAIN.lock();
        try {
            kstat2MatcherList.addMatcher(1, string + "*" + string2);
            try (Kstat2.Kstat2Handle kstat2Handle = new Kstat2.Kstat2Handle();){
                for (n2 = 0; n2 < Integer.MAX_VALUE; ++n2) {
                    Object[] objectArray = new Object[stringArray.length];
                    Kstat2.Kstat2Map kstat2Map = kstat2Handle.lookupMap(string + n2 + string2);
                    for (int i2 = 0; i2 < stringArray.length; ++i2) {
                        objectArray[i2] = kstat2Map.getValue(stringArray[i2]);
                    }
                    arrayList.add(objectArray);
                }
            }
        }
        catch (Kstat2StatusException kstat2StatusException) {
            LOG.debug("Failed to get stats on {}{}{} for names {}: {}", new Object[]{string, n2, string2, Arrays.toString(stringArray), kstat2StatusException.getMessage()});
        }
        finally {
            CHAIN.unlock();
            kstat2MatcherList.free();
        }
        return arrayList;
    }

    public static final class KstatChain
    implements AutoCloseable {
        private final LibKstat.KstatCtl localCtlRef;

        private KstatChain(LibKstat.KstatCtl kstatCtl) {
            this.localCtlRef = kstatCtl;
            this.update();
        }

        public boolean read(LibKstat.Kstat kstat) {
            int n2 = 0;
            while (0 > LibKstat.INSTANCE.kstat_read(this.localCtlRef, kstat, null)) {
                if (11 != Native.getLastError() || 5 <= ++n2) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Failed to read kstat {}:{}:{}", new Object[]{Native.toString(kstat.ks_module, StandardCharsets.US_ASCII), kstat.ks_instance, Native.toString(kstat.ks_name, StandardCharsets.US_ASCII)});
                    }
                    return false;
                }
                Util.sleep(8 << n2);
            }
            return true;
        }

        public LibKstat.Kstat lookup(String string, int n2, String string2) {
            return LibKstat.INSTANCE.kstat_lookup(this.localCtlRef, string, n2, string2);
        }

        public List<LibKstat.Kstat> lookupAll(String string, int n2, String string2) {
            ArrayList<LibKstat.Kstat> arrayList = new ArrayList<LibKstat.Kstat>();
            for (LibKstat.Kstat kstat = LibKstat.INSTANCE.kstat_lookup(this.localCtlRef, string, n2, string2); kstat != null; kstat = kstat.next()) {
                if (string != null && !string.equals(Native.toString(kstat.ks_module, StandardCharsets.US_ASCII)) || n2 >= 0 && n2 != kstat.ks_instance || string2 != null && !string2.equals(Native.toString(kstat.ks_name, StandardCharsets.US_ASCII))) continue;
                arrayList.add(kstat);
            }
            return arrayList;
        }

        public int update() {
            return LibKstat.INSTANCE.kstat_chain_update(this.localCtlRef);
        }

        @Override
        public void close() {
            CHAIN.unlock();
        }
    }
}

