/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.sql.Timestamp;
import java.util.Map;
import java.util.TreeMap;
import org.h2.message.DbException;
import org.h2.mvstore.Chunk;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.type.DataType;
import org.h2.mvstore.type.StringDataType;
import org.h2.store.fs.FilePath;
import org.h2.store.fs.FileUtils;

public class MVStoreTool {
    public static void main(String ... stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            if ("-dump".equals(stringArray[i])) {
                string = stringArray[++i];
                MVStoreTool.dump(string, new PrintWriter(System.out));
                continue;
            }
            if ("-info".equals(stringArray[i])) {
                string = stringArray[++i];
                MVStoreTool.info(string, new PrintWriter(System.out));
                continue;
            }
            if ("-compact".equals(stringArray[i])) {
                string = stringArray[++i];
                MVStoreTool.compact(string, false);
                continue;
            }
            if (!"-compress".equals(stringArray[i])) continue;
            string = stringArray[++i];
            MVStoreTool.compact(string, true);
        }
    }

    public static void dump(String string) {
        MVStoreTool.dump(string, new PrintWriter(System.out));
    }

    public static void info(String string) {
        MVStoreTool.info(string, new PrintWriter(System.out));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dump(String string, Writer writer) {
        PrintWriter printWriter = new PrintWriter(writer, true);
        if (!FilePath.get(string).exists()) {
            printWriter.println("File not found: " + string);
            return;
        }
        long l = FileUtils.size(string);
        printWriter.printf("File %s, %d bytes, %d MB\n", string, l, l / 1024L / 1024L);
        FileChannel fileChannel = null;
        int n = 4096;
        try {
            fileChannel = FilePath.get(string).open("r");
            long l2 = fileChannel.size();
            int n2 = Long.toHexString(l2).length();
            ByteBuffer byteBuffer = ByteBuffer.allocate(4096);
            long l3 = 0L;
            while (l3 < l2) {
                int n3;
                int n4;
                byteBuffer.rewind();
                DataUtils.readFully(fileChannel, l3, byteBuffer);
                byteBuffer.rewind();
                byte by = byteBuffer.get();
                if (by == 72) {
                    printWriter.printf("%0" + n2 + "x fileHeader %s%n", l3, new String(byteBuffer.array(), DataUtils.LATIN).trim());
                    l3 += (long)n;
                    continue;
                }
                if (by != 99) {
                    l3 += (long)n;
                    continue;
                }
                byteBuffer.position(0);
                Chunk chunk = null;
                try {
                    chunk = Chunk.readChunkHeader(byteBuffer, l3);
                }
                catch (IllegalStateException illegalStateException) {
                    l3 += (long)n;
                    continue;
                }
                int n5 = chunk.len * 4096;
                printWriter.printf("%n%0" + n2 + "x chunkHeader %s%n", l3, chunk.toString());
                ByteBuffer byteBuffer2 = ByteBuffer.allocate(n5);
                DataUtils.readFully(fileChannel, l3, byteBuffer2);
                int n6 = byteBuffer.position();
                l3 += (long)n5;
                int n7 = chunk.pageCount;
                TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
                int n8 = 0;
                while (n7 > 0) {
                    byteBuffer2.position(n6);
                    n4 = byteBuffer2.getInt();
                    byteBuffer2.getShort();
                    int n9 = DataUtils.readVarInt(byteBuffer2);
                    n3 = DataUtils.readVarInt(byteBuffer2);
                    byte by2 = byteBuffer2.get();
                    boolean bl = (by2 & 2) != 0;
                    boolean bl2 = (by2 & 1) != 0;
                    printWriter.printf("+%0" + n2 + "x %s, map %x, %d entries, %d bytes%n", n6, (bl2 ? "node" : "leaf") + (bl ? " compressed" : ""), n9, bl2 ? n3 + 1 : n3, n4);
                    n6 += n4;
                    Integer n10 = (Integer)treeMap.get(n9);
                    if (n10 == null) {
                        n10 = 0;
                    }
                    treeMap.put(n9, n10 + n4);
                    n8 += n4;
                    --n7;
                    long[] lArray = null;
                    long[] lArray2 = null;
                    if (bl2) {
                        int n11;
                        lArray = new long[n3 + 1];
                        for (n11 = 0; n11 <= n3; ++n11) {
                            lArray[n11] = byteBuffer2.getLong();
                        }
                        lArray2 = new long[n3 + 1];
                        for (n11 = 0; n11 <= n3; ++n11) {
                            long l4;
                            lArray2[n11] = l4 = DataUtils.readVarLong(byteBuffer2);
                        }
                    }
                    String[] stringArray = new String[n3];
                    if (n9 == 0) {
                        int n12;
                        if (!bl) {
                            for (int i = 0; i < n3; ++i) {
                                String string2;
                                stringArray[i] = string2 = StringDataType.INSTANCE.read(byteBuffer2);
                            }
                        }
                        if (bl2) {
                            for (int i = 0; i < n3; ++i) {
                                long l5 = lArray[i];
                                printWriter.printf("    %d children < %s @ chunk %x +%0" + n2 + "x%n", lArray2[i], stringArray[i], DataUtils.getPageChunkId(l5), DataUtils.getPageOffset(l5));
                            }
                            long l6 = lArray[n3];
                            printWriter.printf("    %d children >= %s @ chunk %x +%0" + n2 + "x%n", lArray2[n3], stringArray.length >= n3 ? null : stringArray[n3], DataUtils.getPageChunkId(l6), DataUtils.getPageOffset(l6));
                            continue;
                        }
                        if (bl) continue;
                        String[] stringArray2 = new String[n3];
                        for (n12 = 0; n12 < n3; ++n12) {
                            String string3;
                            stringArray2[n12] = string3 = StringDataType.INSTANCE.read(byteBuffer2);
                        }
                        for (n12 = 0; n12 < n3; ++n12) {
                            printWriter.println("    " + stringArray[n12] + " = " + stringArray2[n12]);
                        }
                        continue;
                    }
                    if (!bl2) continue;
                    for (int i = 0; i <= n3; ++i) {
                        long l7 = lArray[i];
                        printWriter.printf("    %d children @ chunk %x +%0" + n2 + "x%n", lArray2[i], DataUtils.getPageChunkId(l7), DataUtils.getPageOffset(l7));
                    }
                }
                for (Integer n13 : treeMap.keySet()) {
                    n3 = 100 * (Integer)treeMap.get(n13) / n8;
                    printWriter.printf("map %x: %d%%%n", n13, n3);
                }
                n4 = byteBuffer2.limit() - 128;
                byteBuffer2.position(n4);
                printWriter.printf("+%0" + n2 + "x chunkFooter %s%n", n4, new String(byteBuffer2.array(), byteBuffer2.position(), 128, DataUtils.LATIN).trim());
            }
            printWriter.printf("%n%0" + n2 + "x eof%n", l2);
            printWriter.printf("\n", new Object[0]);
        }
        catch (IOException iOException) {
            printWriter.println("ERROR: " + iOException);
            iOException.printStackTrace(printWriter);
        }
        finally {
            if (fileChannel != null) {
                try {
                    fileChannel.close();
                }
                catch (IOException iOException) {}
            }
        }
        printWriter.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void info(String string, Writer writer) {
        PrintWriter printWriter = new PrintWriter(writer, true);
        if (!FilePath.get(string).exists()) {
            printWriter.println("File not found: " + string);
            return;
        }
        long l = FileUtils.size(string);
        MVStore mVStore = new MVStore.Builder().fileName(string).readOnly().open();
        try {
            Object object;
            MVMap<String, String> mVMap = mVStore.getMetaMap();
            Map<String, Object> map = mVStore.getStoreHeader();
            long l2 = DataUtils.readHexLong(map, "created", 0L);
            TreeMap<Integer, Chunk> treeMap = new TreeMap<Integer, Chunk>();
            long l3 = 0L;
            long l4 = 0L;
            long l5 = 0L;
            long l6 = 0L;
            for (Map.Entry<String, String> entry : mVMap.entrySet()) {
                object = entry.getKey();
                if (!((String)object).startsWith("chunk.")) continue;
                Chunk chunk = Chunk.fromString(entry.getValue());
                treeMap.put(chunk.id, chunk);
                l3 += (long)(chunk.len * 4096);
                l4 += chunk.maxLen;
                l5 += chunk.maxLenLive;
                if (chunk.maxLenLive <= 0L) continue;
                l6 += chunk.maxLen;
            }
            printWriter.printf("Created: %s\n", MVStoreTool.formatTimestamp(l2, l2));
            printWriter.printf("Last modified: %s\n", MVStoreTool.formatTimestamp(FileUtils.lastModified(string), l2));
            printWriter.printf("File length: %d\n", l);
            printWriter.printf("The last chunk is not listed\n", new Object[0]);
            printWriter.printf("Chunk length: %d\n", l3);
            printWriter.printf("Chunk count: %d\n", treeMap.size());
            printWriter.printf("Used space: %d%%\n", MVStoreTool.getPercent(l3, l));
            printWriter.printf("Chunk fill rate: %d%%\n", l4 == 0L ? 100 : MVStoreTool.getPercent(l5, l4));
            printWriter.printf("Chunk fill rate excluding empty chunks: %d%%\n", l6 == 0L ? 100 : MVStoreTool.getPercent(l5, l6));
            for (Map.Entry<String, String> entry : treeMap.entrySet()) {
                object = (Chunk)((Object)entry.getValue());
                long l7 = l2 + ((Chunk)object).time;
                printWriter.printf("  Chunk %d: %s, %d%% used, %d blocks", ((Chunk)object).id, MVStoreTool.formatTimestamp(l7, l2), MVStoreTool.getPercent(((Chunk)object).maxLenLive, ((Chunk)object).maxLen), ((Chunk)object).len);
                if (((Chunk)object).maxLenLive == 0L) {
                    printWriter.printf(", unused: %s", MVStoreTool.formatTimestamp(l2 + ((Chunk)object).unused, l2));
                }
                printWriter.printf("\n", new Object[0]);
            }
            printWriter.printf("\n", new Object[0]);
        }
        catch (Exception exception) {
            printWriter.println("ERROR: " + exception);
            exception.printStackTrace(printWriter);
        }
        finally {
            mVStore.close();
        }
        printWriter.flush();
    }

    private static String formatTimestamp(long l, long l2) {
        String string = new Timestamp(l).toString();
        String string2 = string.substring(0, 19);
        string2 = string2 + " (+" + (l - l2) / 1000L + " s)";
        return string2;
    }

    private static int getPercent(long l, long l2) {
        if (l == 0L) {
            return 0;
        }
        if (l == l2) {
            return 100;
        }
        return (int)(1L + 98L * l / l2);
    }

    public static void compact(String string, boolean bl) {
        String string2 = string + ".tempFile";
        FileUtils.delete(string2);
        MVStoreTool.compact(string, string2, bl);
        try {
            FileUtils.moveAtomicReplace(string2, string);
        }
        catch (DbException dbException) {
            String string3 = string + ".newFile";
            FileUtils.delete(string3);
            FileUtils.move(string2, string3);
            FileUtils.delete(string);
            FileUtils.move(string3, string);
        }
    }

    public static void compactCleanUp(String string) {
        String string2;
        String string3 = string + ".tempFile";
        if (FileUtils.exists(string3)) {
            FileUtils.delete(string3);
        }
        if (FileUtils.exists(string2 = string + ".newFile")) {
            if (FileUtils.exists(string)) {
                FileUtils.delete(string2);
            } else {
                FileUtils.move(string2, string);
            }
        }
    }

    public static void compact(String string, String string2, boolean bl) {
        MVStore mVStore = new MVStore.Builder().fileName(string).readOnly().open();
        FileUtils.delete(string2);
        MVStore.Builder builder = new MVStore.Builder().fileName(string2);
        if (bl) {
            builder.compress();
        }
        MVStore mVStore2 = builder.open();
        MVStoreTool.compact(mVStore, mVStore2);
        mVStore2.close();
        mVStore.close();
    }

    public static void compact(MVStore mVStore, MVStore mVStore2) {
        Object object;
        MVMap<String, String> mVMap = mVStore.getMetaMap();
        MVMap<String, String> mVMap2 = mVStore2.getMetaMap();
        for (Map.Entry<String, String> entry : mVMap.entrySet()) {
            object = entry.getKey();
            if (((String)object).startsWith("chunk.") || ((String)object).startsWith("map.") || ((String)object).startsWith("name.") || ((String)object).startsWith("root.")) continue;
            mVMap2.put((String)object, entry.getValue());
        }
        for (String string : mVStore.getMapNames()) {
            object = new MVMap.Builder().keyType(new GenericDataType()).valueType(new GenericDataType());
            Object m = mVStore.openMap(string, object);
            Object m2 = mVStore2.openMap(string, object);
            ((MVMap)m2).copyFrom(m);
        }
    }

    static class GenericDataType
    implements DataType {
        GenericDataType() {
        }

        @Override
        public int compare(Object object, Object object2) {
            throw DataUtils.newUnsupportedOperationException("Can not compare");
        }

        @Override
        public int getMemory(Object object) {
            return object == null ? 0 : ((byte[])object).length * 8;
        }

        @Override
        public void write(WriteBuffer writeBuffer, Object object) {
            if (object != null) {
                writeBuffer.put((byte[])object);
            }
        }

        @Override
        public void write(WriteBuffer writeBuffer, Object[] objectArray, int n, boolean bl) {
            for (Object object : objectArray) {
                this.write(writeBuffer, object);
            }
        }

        @Override
        public Object read(ByteBuffer byteBuffer) {
            int n = byteBuffer.remaining();
            if (n == 0) {
                return null;
            }
            byte[] byArray = new byte[n];
            byteBuffer.get(byArray);
            return byArray;
        }

        @Override
        public void read(ByteBuffer byteBuffer, Object[] objectArray, int n, boolean bl) {
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = this.read(byteBuffer);
            }
        }
    }
}

