/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.aws.AWSClient;
import com.hazelcast.client.config.ClientAwsConfig;
import com.hazelcast.client.connection.AddressProvider;
import com.hazelcast.client.util.AddressHelper;
import com.hazelcast.config.AwsConfig;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.nio.Address;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class AwsAddressProvider
implements AddressProvider {
    private final ILogger logger;
    private final AWSClient awsClient;
    private volatile Map<String, String> privateToPublic;

    public AwsAddressProvider(ClientAwsConfig awsConfig, LoggingService loggingService) {
        this(new AWSClient((AwsConfig)awsConfig), loggingService);
    }

    AwsAddressProvider(AWSClient awsClient, LoggingService loggingService) {
        this.awsClient = awsClient;
        this.logger = loggingService.getLogger(AwsAddressProvider.class);
    }

    @Override
    public Collection<Address> loadAddresses() {
        this.updateLookupTable();
        Map<String, String> lookupTable = this.getLookupTable();
        ArrayList<Address> addresses = new ArrayList<Address>(lookupTable.size());
        for (String privateAddress : lookupTable.keySet()) {
            addresses.addAll(AddressHelper.getSocketAddresses(privateAddress));
        }
        return addresses;
    }

    private Map<String, String> getLookupTable() {
        Map<String, String> table = this.privateToPublic;
        return table != null ? table : Collections.emptyMap();
    }

    private void updateLookupTable() {
        try {
            this.privateToPublic = this.awsClient.getAddresses();
        }
        catch (Exception e) {
            this.logger.warning("Aws addresses failed to load: " + e.getMessage());
        }
    }
}

