/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.propertyvalue;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.property.ECSSProperty;
import com.helger.css.property.ICSSProperty;
import com.helger.css.propertyvalue.ICSSValue;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class CSSValue
implements ICSSValue {
    private static final Logger s_aLogger = LoggerFactory.getLogger(CSSValue.class);
    private ICSSProperty m_aProperty;
    private String m_sValue;
    private boolean m_bIsImportant;

    public CSSValue(@Nonnull ICSSProperty iCSSProperty, @Nonnull String string, boolean bl) {
        this.setProperty(iCSSProperty);
        this.setValue(string);
        this.setImportant(bl);
    }

    @Nonnull
    public ICSSProperty getProperty() {
        return this.m_aProperty;
    }

    @Override
    @Nonnull
    public ECSSProperty getProp() {
        return this.m_aProperty.getProp();
    }

    @Nonnull
    @Nonempty
    public String getPropertyName() {
        return this.m_aProperty.getPropertyName();
    }

    @Nonnull
    public CSSValue setProperty(@Nonnull ICSSProperty iCSSProperty) {
        this.m_aProperty = (ICSSProperty)ValueEnforcer.notNull((Object)iCSSProperty, (String)"Property");
        return this;
    }

    @Nonnull
    public String getValue() {
        return this.m_sValue;
    }

    @Nonnull
    public CSSValue setValue(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Value");
        if (!this.m_aProperty.isValidValue(string)) {
            s_aLogger.warn("CSS: the value '" + string + "' is not valid for property '" + this.m_aProperty.getPropertyName() + "'");
        }
        if (string.contains(" !important")) {
            s_aLogger.warn("CSS: the value '" + string + "' should not contain the '" + " !important" + "' string! Use 'setImportant' method instead.");
        }
        this.m_sValue = string.trim();
        return this;
    }

    public boolean isImportant() {
        return this.m_bIsImportant;
    }

    @Nonnull
    public CSSValue setImportant(boolean bl) {
        this.m_bIsImportant = bl;
        return this;
    }

    @Override
    @Nonnull
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        iCSSWriterSettings.checkVersionRequirements(this.m_aProperty);
        return this.m_aProperty.getPropertyName() + ':' + this.m_sValue + (StringHelper.hasText((String)this.m_sValue) && this.m_bIsImportant ? " !important" : "") + ';';
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSValue cSSValue = (CSSValue)object;
        return this.m_aProperty.getProp().equals(cSSValue.m_aProperty.getProp()) && this.m_sValue.equals(cSSValue.m_sValue) && this.m_bIsImportant == cSSValue.m_bIsImportant;
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Enum)this.m_aProperty.getProp()).append((Object)this.m_sValue).append(this.m_bIsImportant).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("property", (Object)this.m_aProperty).append("value", (Object)this.m_sValue).append("important", this.m_bIsImportant).toString();
    }
}

